/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001q4Aa\u0005\u000b\u0001;!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\n1Ca\u0001\u0015\u0001!\u0002\u0013i\u0005bB)\u0001\u0005\u0004%I\u0001\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B'\t\u000fM\u0003\u0001\u0019!C\u0005\u0019\"9A\u000b\u0001a\u0001\n\u0013)\u0006B\u00020\u0001A\u0003&Q\nC\u0004`\u0001\u0001\u0007I\u0011\u0002'\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\"11\r\u0001Q!\n5CQ\u0001\u001a\u0001\u0005B\u0015DQ!\u001b\u0001\u0005B)DQa\u001b\u0001\u0005\n1DQa\u001e\u0001\u0005\n1DQ\u0001\u001f\u0001\u0005\ne\u0014A$\u0012>Ta\u0006\u00148.Q,T\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'O\u0003\u0002\u0016-\u0005\u00191oM1\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001=\u0019\u0002\u0004CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013\u0001B1vi\"T!a\u000b\u0017\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"A\u0017\u0002\u0007\r|W.\u0003\u00020Q\t1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u00022i5\t!G\u0003\u00024-\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0017aA;sSB\u0011\u0001hO\u0007\u0002s)\u0011!HI\u0001\u0004]\u0016$\u0018B\u0001\u001f:\u0005\r)&+S\u0001\u0005G>tg\r\u0005\u0002@\u00076\t\u0001I\u0003\u0002>\u0003*\u0011!\tG\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011\u0003%!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f&S\u0005C\u0001%\u0001\u001b\u0005!\u0002\"\u0002\u001c\u0004\u0001\u00049\u0004\"B\u001f\u0004\u0001\u0004q\u0014\u0001\u0007#fM\u0006,H\u000e^!dG\u0016\u001c8oS3z\u0019>\u001c\u0017\r^5p]V\tQ\n\u0005\u0002 \u001d&\u0011q\n\t\u0002\u0007'R\u0014\u0018N\\4\u00023\u0011+g-Y;mi\u0006\u001b7-Z:t\u0017\u0016LHj\\2bi&|g\u000eI\u0001\u0019\t\u00164\u0017-\u001e7u'\u0016\u001c'/\u001a;LKfdunY1uS>t\u0017!\u0007#fM\u0006,H\u000e^*fGJ,GoS3z\u0019>\u001c\u0017\r^5p]\u0002\n\u0011\"Y2dKN\u001c8*Z=\u0002\u001b\u0005\u001c7-Z:t\u0017\u0016Lx\fJ3r)\t1F\f\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0003V]&$\bbB/\n\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014AC1dG\u0016\u001c8oS3zA\u0005I1/Z2sKR\\U-_\u0001\u000eg\u0016\u001c'/\u001a;LKf|F%Z9\u0015\u0005Y\u0013\u0007bB/\r\u0003\u0003\u0005\r!T\u0001\u000bg\u0016\u001c'/\u001a;LKf\u0004\u0013AD4fi\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0002MB\u0011qeZ\u0005\u0003Q\"\u0012a\"Q,T\u0007J,G-\u001a8uS\u0006d7/A\u0004sK\u001a\u0014Xm\u001d5\u0015\u0003Y\u000b1cZ3u+B$\u0017\r^3e\u0003\u000e\u001cWm]:LKf$\u0012!\u001c\t\u0003]Vt!a\\:\u0011\u0005ADV\"A9\u000b\u0005Id\u0012A\u0002\u001fs_>$h(\u0003\u0002u1\u00061\u0001K]3eK\u001aL!a\u0014<\u000b\u0005QD\u0016aE4fiV\u0003H-\u0019;fIN+7M]3u\u0017\u0016L\u0018AE4fi.+\u0017P\u0012:p[2{7-\u0019;j_:$\"!\u001c>\t\u000bm\u0014\u0002\u0019A7\u0002\u0017-,\u0017\u0010T8dCRLwN\u001c")
public class EzSparkAWSCredentialProvider
implements AWSCredentialsProvider,
Logging {
    private final String DefaultAccessKeyLocation;
    private final String DefaultSecretKeyLocation;
    private String accessKey;
    private String secretKey;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String DefaultAccessKeyLocation() {
        return this.DefaultAccessKeyLocation;
    }

    private String DefaultSecretKeyLocation() {
        return this.DefaultSecretKeyLocation;
    }

    private String accessKey() {
        return this.accessKey;
    }

    private void accessKey_$eq(String x$1) {
        this.accessKey = x$1;
    }

    private String secretKey() {
        return this.secretKey;
    }

    private void secretKey_$eq(String x$1) {
        this.secretKey = x$1;
    }

    public AWSCredentials getCredentials() {
        return new BasicAWSCredentials(this.accessKey(), this.secretKey());
    }

    public void refresh() {
        this.accessKey_$eq(this.getUpdatedAccessKey());
        this.secretKey_$eq(this.getUpdatedSecretKey());
    }

    private String getUpdatedAccessKey() {
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Updating accessKey");
        String accessKeyLocation = Properties$.MODULE$.envOrElse("AWS_ACCESS_KEY_LOCATION", this.DefaultAccessKeyLocation());
        return this.getKeyFromLocation(accessKeyLocation);
    }

    private String getUpdatedSecretKey() {
        String string;
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Updating secretKey");
        String secretKeyLocation = Properties$.MODULE$.envOrElse("AWS_SECRET_KEY_LOCATION", this.DefaultSecretKeyLocation());
        try {
            string = this.getKeyFromLocation(secretKeyLocation);
        }
        catch (AmazonClientException amazonClientException) {
            string = "defaultSecretKeyValue";
        }
        return string;
    }

    private String getKeyFromLocation(String keyLocation) {
        String string;
        if (keyLocation.isEmpty()) {
            throw new AmazonClientException("Key path is not set");
        }
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(27).append("Reading key from location: ").append(keyLocation).toString());
        try (BufferedSource keySource = Source$.MODULE$.fromFile(keyLocation, Codec$.MODULE$.fallbackSystemCodec());){
            string = keySource.mkString().trim();
        }
        return string;
    }

    public EzSparkAWSCredentialProvider(URI uri, Configuration conf) {
        Logging.$init$((Logging)this);
        this.DefaultAccessKeyLocation = "/etc/secrets/ezua/.auth_token";
        this.DefaultSecretKeyLocation = "";
        this.accessKey = "";
        this.secretKey = "";
        this.refresh();
    }
}

