/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001F\u000b\u0001=!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001da\u0005A1A\u0005\n5Ca!\u0015\u0001!\u0002\u0013q\u0005b\u0002*\u0001\u0005\u0004%I!\u0014\u0005\u0007'\u0002\u0001\u000b\u0011\u0002(\t\u000fQ\u0003\u0001\u0019!C\u0005\u001b\"9Q\u000b\u0001a\u0001\n\u00131\u0006BB0\u0001A\u0003&a\nC\u0004a\u0001\u0001\u0007I\u0011B'\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\"1A\r\u0001Q!\n9CQ!\u001a\u0001\u0005B\u0019DQA\u001b\u0001\u0005B-DQ\u0001\u001c\u0001\u0005\n5DQ\u0001\u001f\u0001\u0005\n5DQ!\u001f\u0001\u0005\niDQ! \u0001\u0005\n-\u0014A$\u0012>Ta\u0006\u00148.Q,T\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'O\u0003\u0002\u0017/\u0005\u00191oM1\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001?\u001d\n\u0004C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013\u0001B1vi\"T!\u0001L\u0017\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001\u0018\u0002\u0007\r|W.\u0003\u00021S\t1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u00023k5\t1G\u0003\u00025/\u0005A\u0011N\u001c;fe:\fG.\u0003\u00027g\t9Aj\\4hS:<\u0017aA;sSB\u0011\u0011\bP\u0007\u0002u)\u00111hI\u0001\u0004]\u0016$\u0018BA\u001f;\u0005\r)&+S\u0001\u0005G>tg\r\u0005\u0002A\t6\t\u0011I\u0003\u0002?\u0005*\u00111)G\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0015\u000b%!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011*[\u0005CA%\u0001\u001b\u0005)\u0002\"B\u001c\u0004\u0001\u0004A\u0004\"\u0002 \u0004\u0001\u0004y\u0014\u0001\u0007#fM\u0006,H\u000e^!dG\u0016\u001c8oS3z\u0019>\u001c\u0017\r^5p]V\ta\n\u0005\u0002!\u001f&\u0011\u0001+\t\u0002\u0007'R\u0014\u0018N\\4\u00023\u0011+g-Y;mi\u0006\u001b7-Z:t\u0017\u0016LHj\\2bi&|g\u000eI\u0001\u0019\t\u00164\u0017-\u001e7u'\u0016\u001c'/\u001a;LKfdunY1uS>t\u0017!\u0007#fM\u0006,H\u000e^*fGJ,GoS3z\u0019>\u001c\u0017\r^5p]\u0002\n\u0011\"Y2dKN\u001c8*Z=\u0002\u001b\u0005\u001c7-Z:t\u0017\u0016Lx\fJ3r)\t9V\f\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0003V]&$\bb\u00020\n\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014AC1dG\u0016\u001c8oS3zA\u0005I1/Z2sKR\\U-_\u0001\u000eg\u0016\u001c'/\u001a;LKf|F%Z9\u0015\u0005]\u001b\u0007b\u00020\r\u0003\u0003\u0005\rAT\u0001\u000bg\u0016\u001c'/\u001a;LKf\u0004\u0013AD4fi\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0002OB\u0011\u0001\u0006[\u0005\u0003S&\u0012a\"Q,T\u0007J,G-\u001a8uS\u0006d7/A\u0004sK\u001a\u0014Xm\u001d5\u0015\u0003]\u000b1cZ3u+B$\u0017\r^3e\u0003\u000e\u001cWm]:LKf$\u0012A\u001c\t\u0003_Zt!\u0001\u001d;\u0011\u0005ELV\"\u0001:\u000b\u0005Ml\u0012A\u0002\u001fs_>$h(\u0003\u0002v3\u00061\u0001K]3eK\u001aL!\u0001U<\u000b\u0005UL\u0016aE4fiV\u0003H-\u0019;fIN+7M]3u\u0017\u0016L\u0018AE4fi.+\u0017P\u0012:p[2{7-\u0019;j_:$\"A\\>\t\u000bq\u0014\u0002\u0019\u00018\u0002\u0017-,\u0017\u0010T8dCRLwN\\\u0001\u0016gR\f'\u000f^&fsV\u0003H-\u0019;f\u001b>t\u0017\u000e^8s\u0001")
public class EzSparkAWSCredentialProvider
implements AWSCredentialsProvider,
Logging {
    private final String DefaultAccessKeyLocation;
    private final String DefaultSecretKeyLocation;
    private String accessKey;
    private String secretKey;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String DefaultAccessKeyLocation() {
        return this.DefaultAccessKeyLocation;
    }

    private String DefaultSecretKeyLocation() {
        return this.DefaultSecretKeyLocation;
    }

    private String accessKey() {
        return this.accessKey;
    }

    private void accessKey_$eq(String x$1) {
        this.accessKey = x$1;
    }

    private String secretKey() {
        return this.secretKey;
    }

    private void secretKey_$eq(String x$1) {
        this.secretKey = x$1;
    }

    public AWSCredentials getCredentials() {
        return new BasicAWSCredentials(this.accessKey(), this.secretKey());
    }

    public void refresh() {
        this.accessKey_$eq(this.getUpdatedAccessKey());
        this.secretKey_$eq(this.getUpdatedSecretKey());
    }

    private String getUpdatedAccessKey() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating accessKey");
        String accessKeyLocation = Properties$.MODULE$.envOrElse("AWS_ACCESS_KEY_LOCATION", this.DefaultAccessKeyLocation());
        return this.getKeyFromLocation(accessKeyLocation);
    }

    private String getUpdatedSecretKey() {
        String string;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating secretKey");
        String secretKeyLocation = Properties$.MODULE$.envOrElse("AWS_SECRET_KEY_LOCATION", this.DefaultSecretKeyLocation());
        try {
            string = this.getKeyFromLocation(secretKeyLocation);
        }
        catch (AmazonClientException amazonClientException) {
            string = "defaultSecretKeyValue";
        }
        return string;
    }

    private String getKeyFromLocation(String keyLocation) {
        String string;
        if (keyLocation.isEmpty()) {
            throw new AmazonClientException("Key path is not set");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Reading key from location: ").append(keyLocation).toString());
        try (BufferedSource keySource = Source$.MODULE$.fromFile(keyLocation, Codec$.MODULE$.fallbackSystemCodec());){
            string = keySource.mkString().trim();
        }
        return string;
    }

    private void startKeyUpdateMonitor() {
        String accessKeyLocation = Properties$.MODULE$.envOrElse("AWS_ACCESS_KEY_LOCATION", this.DefaultAccessKeyLocation());
        File accessKeyFile = new File(accessKeyLocation);
        FileAlterationObserver observer = new FileAlterationObserver(accessKeyFile.getParent());
        observer.addListener(new FileAlterationListener(this, accessKeyFile){
            private final /* synthetic */ EzSparkAWSCredentialProvider $outer;
            private final File accessKeyFile$1;

            public void onFileChange(File file) {
                String string = file.getName();
                String string2 = this.accessKeyFile$1.getName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Access key file changed: ").append(file.getName()).toString());
                    this.$outer.refresh();
                    return;
                }
            }

            public void onFileCreate(File file) {
                String string = file.getName();
                String string2 = this.accessKeyFile$1.getName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Access key file created: ").append(file.getName()).toString());
                    this.$outer.refresh();
                    return;
                }
            }

            public void onFileDelete(File file) {
            }

            public void onDirectoryChange(File directory) {
            }

            public void onDirectoryCreate(File directory) {
            }

            public void onDirectoryDelete(File directory) {
            }

            public void onStart(FileAlterationObserver observer) {
            }

            public void onStop(FileAlterationObserver observer) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.accessKeyFile$1 = accessKeyFile$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChange$1(java.io.File ), $anonfun$onFileCreate$1(java.io.File )}, serializedLambda);
            }
        });
        FileAlterationMonitor monitor = new FileAlterationMonitor(10000L, new FileAlterationObserver[]{observer});
        try {
            monitor.start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error starting file monitor", e);
        }
    }

    public EzSparkAWSCredentialProvider(URI uri, Configuration conf) {
        Logging.$init$((Logging)this);
        this.DefaultAccessKeyLocation = "/etc/secrets/ezua/.auth_token";
        this.DefaultSecretKeyLocation = "";
        this.accessKey = "";
        this.secretKey = "";
        this.refresh();
        this.startKeyUpdateMonitor();
    }
}

