/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.search.CoveringQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class SubsetQueryPlugin
extends QParserPlugin {
    public static final String SETVAL_PARAM_NAME = "set_value";
    public static final String SETVAL_FIELD_NAME = "set_field";
    public static final String COUNT_FIELD_NAME = "count_field";
    public static final String MISSING_VAL_ALLOWED = "allow_missing_val";
    public static final String WILDCARD_CHAR = "wildcard_token";

    public void init(NamedList arg0) {
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            public Query parse() throws SyntaxError {
                String fieldName = (String)Preconditions.checkNotNull((Object)this.localParams.get(SubsetQueryPlugin.SETVAL_FIELD_NAME));
                String countFieldName = (String)Preconditions.checkNotNull((Object)this.localParams.get(SubsetQueryPlugin.COUNT_FIELD_NAME));
                boolean allowMissingValues = Boolean.parseBoolean((String)Preconditions.checkNotNull((Object)this.localParams.get(SubsetQueryPlugin.MISSING_VAL_ALLOWED)));
                String wildcardToken = this.localParams.get(SubsetQueryPlugin.WILDCARD_CHAR);
                LongValuesSource minimumNumberMatch = LongValuesSource.fromIntField((String)countFieldName);
                ArrayList<Object> queries = new ArrayList<Object>();
                String fieldVals = (String)Preconditions.checkNotNull((Object)this.localParams.get(SubsetQueryPlugin.SETVAL_PARAM_NAME));
                for (String v : fieldVals.split(",")) {
                    queries.add(new TermQuery(new Term(fieldName, v)));
                }
                if (wildcardToken != null && !wildcardToken.equals("")) {
                    queries.add(new TermQuery(new Term(fieldName, wildcardToken)));
                }
                if (allowMissingValues) {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD));
                    builder.add(new BooleanClause((Query)new WildcardQuery(new Term(fieldName, "*")), BooleanClause.Occur.MUST_NOT));
                    queries.add(builder.build());
                }
                return new CoveringQuery(queries, minimumNumberMatch);
            }
        };
    }
}

