/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import javax.script.ScriptEngine;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptConditionEvaluator;
import org.apache.ranger.plugin.util.ScriptEngineCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerScriptConditionEvaluator.class);
    private static volatile ScriptEngineCreator SCRIPT_ENGINE_CREATOR = null;
    private static volatile boolean SCRIPT_ENGINE_CREATOR_INITIALIZED = false;

    public static ScriptEngine createScriptEngine(String engineName, String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ScriptEngineUtil.createScriptEngine(engineName=" + engineName + ", serviceType=" + serviceType + "): engineName ignored");
        }
        return ScriptEngineUtil.createScriptEngine(serviceType);
    }

    public static ScriptEngine createScriptEngine(String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ScriptEngineUtil.createScriptEngine(serviceType=" + serviceType + ")");
        }
        ScriptEngine ret = null;
        ScriptEngineCreator creator = ScriptEngineUtil.getScriptEngineCreator(serviceType);
        if (creator != null) {
            ClassLoader pluginClsLoader;
            ret = creator.getScriptEngine(null);
            if (ret == null && (pluginClsLoader = ScriptEngineUtil.getPrevActiveClassLoader(serviceType)) != null) {
                ret = creator.getScriptEngine(pluginClsLoader);
            }
        } else {
            LOG.info("createScriptEngine(serviceType={}): no engine creator found", (Object)serviceType);
        }
        if (ret == null) {
            LOG.warn("createScriptEngine(serviceType={}): failed to create script engine", (Object)serviceType);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ScriptEngineUtil.createScriptEngine(serviceType={}): ret={}", (Object)serviceType, (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScriptEngineCreator getScriptEngineCreator(String serviceType) {
        boolean isInitialized = SCRIPT_ENGINE_CREATOR_INITIALIZED;
        if (isInitialized) return SCRIPT_ENGINE_CREATOR;
        Class<ScriptEngineUtil> clazz = ScriptEngineUtil.class;
        synchronized (ScriptEngineUtil.class) {
            isInitialized = SCRIPT_ENGINE_CREATOR_INITIALIZED;
            if (!isInitialized) {
                ScriptEngineUtil.initScriptEngineCreator(serviceType);
            }
            SCRIPT_ENGINE_CREATOR_INITIALIZED = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return SCRIPT_ENGINE_CREATOR;
        }
    }

    private static void initScriptEngineCreator(String serviceType) {
        String[] engineCreators;
        for (String creatorClsName : engineCreators = new String[]{"org.apache.ranger.plugin.util.NashornScriptEngineCreator", "org.apache.ranger.plugin.util.GraalScriptEngineCreator", "org.apache.ranger.plugin.util.JavaScriptEngineCreator"}) {
            ClassLoader prevActiveClassLoader;
            ScriptEngineCreator creator = null;
            try {
                Class<?> creatorClass = Class.forName(creatorClsName);
                creator = (ScriptEngineCreator)creatorClass.newInstance();
            }
            catch (Throwable t) {
                LOG.warn("initScriptEngineCreator(): failed to instantiate engine creator {}", (Object)creatorClsName, (Object)t);
            }
            if (creator == null) continue;
            ScriptEngine engine = creator.getScriptEngine(null);
            if (engine == null && (prevActiveClassLoader = ScriptEngineUtil.getPrevActiveClassLoader(serviceType)) != null) {
                LOG.debug("initScriptEngineCreator(): trying to create engine using plugin-class-loader for service-type {}", (Object)serviceType);
                engine = creator.getScriptEngine(prevActiveClassLoader);
                if (engine == null) {
                    LOG.warn("initScriptEngineCreator(): failed to create engine using plugin-class-loader by creator {}", (Object)creatorClsName);
                }
            }
            if (engine == null) continue;
            SCRIPT_ENGINE_CREATOR = creator;
            break;
        }
    }

    private static ClassLoader getPrevActiveClassLoader(String serviceType) {
        ClassLoader ret = null;
        try {
            RangerPluginClassLoader pluginClassLoader = RangerPluginClassLoader.getInstance((String)serviceType, null);
            if (pluginClassLoader != null) {
                ret = pluginClassLoader.getPrevActiveClassLoader();
            } else {
                LOG.debug("Cannot get plugin-class-loader for serviceType {}", (Object)serviceType);
            }
        }
        catch (Throwable excp) {
            LOG.debug("Failed to get plugin-class-loader for serviceType {}", (Object)serviceType, (Object)excp);
        }
        return ret;
    }
}

