/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;

@InterfaceAudience.Private
public class KMSMDCFilter
implements Filter {
    static final String RANGER_KMS_REST_API_PATH = "/kms/api/status";
    private static final ThreadLocal<Data> DATA_TL = new ThreadLocal();

    public static UserGroupInformation getUgi() {
        return DATA_TL.get().ugi;
    }

    public static String getMethod() {
        return DATA_TL.get().method;
    }

    public static String getURL() {
        return DATA_TL.get().url;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String path = ((HttpServletRequest)request).getRequestURI();
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains; preload");
            if (path.startsWith(RANGER_KMS_REST_API_PATH)) {
                chain.doFilter(request, (ServletResponse)resp);
            } else {
                DATA_TL.remove();
                UserGroupInformation ugi = HttpUserGroupInformation.get();
                String method = ((HttpServletRequest)request).getMethod();
                StringBuffer requestURL = ((HttpServletRequest)request).getRequestURL();
                String queryString = ((HttpServletRequest)request).getQueryString();
                if (queryString != null) {
                    requestURL.append("?").append(queryString);
                }
                DATA_TL.set(new Data(ugi, method, requestURL.toString()));
                chain.doFilter(request, (ServletResponse)resp);
            }
        }
        finally {
            DATA_TL.remove();
        }
    }

    public void destroy() {
    }

    private static class Data {
        private UserGroupInformation ugi;
        private String method;
        private String url;

        private Data(UserGroupInformation ugi, String method, String url) {
            this.ugi = ugi;
            this.method = method;
            this.url = url;
        }
    }
}

