/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKafkaAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKafkaAuditHandler.class);
    private AuthzAuditEvent auditEvent = null;

    public void processResult(RangerAccessResult result) {
        if (!this.isAuditingNeeded(result)) {
            return;
        }
        this.auditEvent = super.getAuthzEvents(result);
    }

    private boolean isAuditingNeeded(RangerAccessResult result) {
        boolean ret = true;
        boolean isAllowed = result.getIsAllowed();
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResourceImpl resource = (RangerAccessResourceImpl)request.getResource();
        String resourceName = (String)resource.getValue("cluster");
        if (resourceName != null && request.getAccessType().equalsIgnoreCase("create") && !isAllowed) {
            ret = false;
        }
        return ret;
    }

    public void flushAudit() {
        if (LOG.isDebugEnabled()) {
            LOG.info("==> RangerYarnAuditHandler.flushAudit(AuditEvent: " + this.auditEvent + ")");
        }
        if (this.auditEvent != null) {
            super.logAuthzAudit(this.auditEvent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("<== RangerYarnAuditHandler.flushAudit(AuditEvent: " + this.auditEvent + ")");
        }
    }
}

