/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.hive.client.HiveResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceHive
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceHive.class);
    public static final String RESOURCE_DATABASE = "database";
    public static final String RESOURCE_TABLE = "table";
    public static final String RESOURCE_UDF = "udf";
    public static final String RESOURCE_COLUMN = "column";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_SELECT = "select";
    public static final String ACCESS_TYPE_READ = "read";
    public static final String ACCESS_TYPE_ALL = "all";
    public static final String WILDCARD_ASTERISK = "*";
    public static final String HIVE_DB_DEFAULT = "default";
    public static final String HIVE_DB_INFOMATION_SCHEMA = "information_schema";
    public static final String DEFAULT_DB_POLICYNAME = "default database tables columns";
    public static final String INFORMATION_SCHEMA_DB_POLICYNAME = "Information_schema database tables columns";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHive.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = HiveResourceMgr.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException e) {
                LOG.error("<== RangerServiceHive.validateConfig Error:" + (Object)((Object)e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHive.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHive.lookupResource Context: (" + context + ")");
        }
        if (context != null && context.getUserInput() != null && !context.getUserInput().isEmpty()) {
            try {
                ret = HiveResourceMgr.getHiveResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceHive.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHive.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHive.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            Map policyResources = defaultPolicy.getResources();
            if (defaultPolicy.getName().contains(ACCESS_TYPE_ALL) && StringUtils.isNotBlank((String)this.lookUpUser)) {
                RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
                policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
                policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ)));
                policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
                defaultPolicy.getPolicyItems().add(policyItemForLookupUser);
            }
            if (policyResources.size() == 1 && this.hasWildcardAsteriskResource(policyResources, RESOURCE_DATABASE)) {
                RangerPolicy.RangerPolicyItem policyItemPublic = new RangerPolicy.RangerPolicyItem();
                policyItemPublic.setGroups(Collections.singletonList("public"));
                policyItemPublic.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_CREATE)));
                RangerPolicy.RangerPolicyItem policyItemOwner = new RangerPolicy.RangerPolicyItem();
                policyItemOwner.setUsers(Collections.singletonList("{OWNER}"));
                policyItemOwner.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ALL)));
                policyItemOwner.setDelegateAdmin(Boolean.valueOf(true));
                defaultPolicy.getPolicyItems().add(policyItemPublic);
                defaultPolicy.getPolicyItems().add(policyItemOwner);
                continue;
            }
            if (!(policyResources.size() == 2 && this.hasWildcardAsteriskResource(policyResources, RESOURCE_DATABASE, RESOURCE_TABLE) || policyResources.size() == 2 && this.hasWildcardAsteriskResource(policyResources, RESOURCE_DATABASE, RESOURCE_UDF)) && (policyResources.size() != 3 || !this.hasWildcardAsteriskResource(policyResources, RESOURCE_DATABASE, RESOURCE_TABLE, RESOURCE_COLUMN))) continue;
            RangerPolicy.RangerPolicyItem policyItemOwner = new RangerPolicy.RangerPolicyItem();
            policyItemOwner.setUsers(Collections.singletonList("{OWNER}"));
            policyItemOwner.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ALL)));
            policyItemOwner.setDelegateAdmin(Boolean.valueOf(true));
            defaultPolicy.getPolicyItems().add(policyItemOwner);
        }
        RangerPolicy defaultDBPolicy = this.createDefaultDBPolicy();
        ret.add(defaultDBPolicy);
        RangerPolicy informationSchemaPolicy = this.createInformationSchemaPolicy();
        ret.add(informationSchemaPolicy);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHive.getDefaultRangerPolicies()");
        }
        return ret;
    }

    private boolean hasWildcardAsteriskResource(Map<String, RangerPolicy.RangerPolicyResource> policyResources, String ... resourceNames) {
        for (String resourceName : resourceNames) {
            List values;
            RangerPolicy.RangerPolicyResource resource = policyResources.get(resourceName);
            List list = values = resource != null ? resource.getValues() : null;
            if (values != null && values.contains(WILDCARD_ASTERISK)) continue;
            return false;
        }
        return true;
    }

    private RangerPolicy createDefaultDBPolicy() {
        RangerPolicy defaultDBPolicy = new RangerPolicy();
        defaultDBPolicy.setName(DEFAULT_DB_POLICYNAME);
        defaultDBPolicy.setService(this.serviceName);
        defaultDBPolicy.setResources(this.createDefaultDBPolicyResource());
        defaultDBPolicy.setPolicyItems(this.createDefaultDBPolicyItem());
        return defaultDBPolicy;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> createDefaultDBPolicyResource() {
        HashMap<String, RangerPolicy.RangerPolicyResource> resources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        resources.put(RESOURCE_DATABASE, new RangerPolicy.RangerPolicyResource(Arrays.asList(HIVE_DB_DEFAULT), Boolean.valueOf(false), Boolean.valueOf(false)));
        resources.put(RESOURCE_TABLE, new RangerPolicy.RangerPolicyResource(WILDCARD_ASTERISK));
        resources.put(RESOURCE_COLUMN, new RangerPolicy.RangerPolicyResource(WILDCARD_ASTERISK));
        return resources;
    }

    private List<RangerPolicy.RangerPolicyItem> createDefaultDBPolicyItem() {
        ArrayList<RangerPolicy.RangerPolicyItemAccess> accesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        accesses.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_CREATE));
        RangerPolicy.RangerPolicyItem item = new RangerPolicy.RangerPolicyItem(accesses, null, Arrays.asList("public"), null, null, Boolean.valueOf(false));
        return Collections.singletonList(item);
    }

    private RangerPolicy createInformationSchemaPolicy() {
        RangerPolicy informationSchemaPolicy = new RangerPolicy();
        informationSchemaPolicy.setName(INFORMATION_SCHEMA_DB_POLICYNAME);
        informationSchemaPolicy.setService(this.serviceName);
        informationSchemaPolicy.setResources(this.createInformationSchemaPolicyResource());
        informationSchemaPolicy.setPolicyItems(this.createInformationSchemaPolicyItem());
        return informationSchemaPolicy;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> createInformationSchemaPolicyResource() {
        HashMap<String, RangerPolicy.RangerPolicyResource> resources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        resources.put(RESOURCE_DATABASE, new RangerPolicy.RangerPolicyResource(Arrays.asList(HIVE_DB_INFOMATION_SCHEMA), Boolean.valueOf(false), Boolean.valueOf(false)));
        resources.put(RESOURCE_TABLE, new RangerPolicy.RangerPolicyResource(WILDCARD_ASTERISK));
        resources.put(RESOURCE_COLUMN, new RangerPolicy.RangerPolicyResource(WILDCARD_ASTERISK));
        return resources;
    }

    private List<RangerPolicy.RangerPolicyItem> createInformationSchemaPolicyItem() {
        ArrayList<RangerPolicy.RangerPolicyItemAccess> accesses = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        accesses.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_SELECT));
        RangerPolicy.RangerPolicyItem item = new RangerPolicy.RangerPolicyItem(accesses, null, Arrays.asList("public"), null, null, Boolean.valueOf(false));
        return Collections.singletonList(item);
    }
}

