/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHdfsAuthorizer
extends INodeAttributeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "hdfs";
    private static final String RANGER_HDFS_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.hadoop.RangerHdfsAuthorizer";
    private INodeAttributeProvider rangerHdfsAuthorizerImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerHdfsAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
    }

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_HDFS_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerHdfsAuthorizerImpl = (INodeAttributeProvider)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerHdfsPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.init()");
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.start()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerHdfsAuthorizerImpl.start();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.start()");
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.stop()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerHdfsAuthorizerImpl.stop();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodeAttributes getAttributes(String fullPath, INodeAttributes inode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getAttributes(" + fullPath + ")");
        }
        INodeAttributes ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerHdfsAuthorizerImpl.getAttributes(fullPath, inode);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getAttributes(" + fullPath + "): " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodeAttributes getAttributes(String[] pathElements, INodeAttributes inode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getAttributes(pathElementsCount=" + (pathElements == null ? 0 : pathElements.length) + ")");
        }
        INodeAttributes ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerHdfsAuthorizerImpl.getAttributes(pathElements, inode);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getAttributes(pathElementsCount=" + (pathElements == null ? 0 : pathElements.length) + "): " + ret);
        }
        return ret;
    }

    public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        INodeAttributeProvider.AccessControlEnforcer ret = null;
        ret = this.rangerHdfsAuthorizerImpl.getExternalAccessControlEnforcer(defaultEnforcer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

