/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangerHBasePlugin
extends RangerBasePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHBasePlugin.class);
    boolean isHBaseShuttingDown = false;

    public RangerHBasePlugin(String appType) {
        super("hbase", appType);
    }

    public void setHBaseShuttingDown(boolean hbaseShuttingDown) {
        this.isHBaseShuttingDown = hbaseShuttingDown;
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerAccessResult ret = null;
        if (this.isHBaseShuttingDown) {
            ret = new RangerAccessResult(0, this.getServiceName(), this.getServiceDef(), request);
            ret.setIsAllowed(true);
            ret.setIsAudited(false);
            LOG.warn("Auth request came after HBase shutdown....");
        } else {
            ret = super.isAccessAllowed(request, resultProcessor);
        }
        return ret;
    }
}

