/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.AuthorizationSession;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationFilter
extends FilterBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)RangerAuthorizationFilter.class.getName());
    final Set<String> _familiesAccessAllowed;
    final Set<String> _familiesAccessDenied;
    final Set<String> _familiesAccessIndeterminate;
    final Map<String, Set<String>> _columnsAccessAllowed;
    final AuthorizationSession _session;
    final HbaseAuditHandler _auditHandler = HbaseFactory.getInstance().getAuditHandler();

    public RangerAuthorizationFilter(AuthorizationSession session, Set<String> familiesAccessAllowed, Set<String> familiesAccessDenied, Set<String> familiesAccessIndeterminate, Map<String, Set<String>> columnsAccessAllowed) {
        this._familiesAccessAllowed = familiesAccessAllowed;
        this._familiesAccessDenied = familiesAccessDenied;
        this._familiesAccessIndeterminate = familiesAccessIndeterminate;
        this._columnsAccessAllowed = columnsAccessAllowed;
        this._session = session;
        this._session.auditHandler(this._auditHandler);
    }

    public Filter.ReturnCode filterKeyValue(Cell kv) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> filterKeyValue");
        }
        String family = null;
        byte[] familyBytes = CellUtil.cloneFamily((Cell)kv);
        if (familyBytes != null && familyBytes.length > 0) {
            family = Bytes.toString((byte[])familyBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("filterKeyValue: evaluating family[" + family + "].");
            }
        }
        String column = null;
        byte[] qualifier = CellUtil.cloneQualifier((Cell)kv);
        if (qualifier != null && qualifier.length > 0) {
            column = Bytes.toString((byte[])qualifier);
            if (LOG.isDebugEnabled()) {
                LOG.debug("filterKeyValue: evaluating column[" + column + "].");
            }
        } else {
            LOG.warn("filterKeyValue: empty/null column set! Unexpected!");
        }
        Filter.ReturnCode result = Filter.ReturnCode.NEXT_COL;
        boolean authCheckNeeded = false;
        if (family == null) {
            LOG.warn("filterKeyValue: Unexpected - null/empty family! Access denied!");
        } else if (this._familiesAccessDenied.contains(family)) {
            LOG.debug("filterKeyValue: family found in access denied families cache.  Access denied.");
        } else if (this._columnsAccessAllowed.containsKey(family)) {
            LOG.debug("filterKeyValue: family found in column level access results cache.");
            if (this._columnsAccessAllowed.get(family).contains(column)) {
                LOG.debug("filterKeyValue: family/column found in column level access results cache. Access allowed.");
                result = Filter.ReturnCode.INCLUDE;
            } else {
                LOG.debug("filterKeyValue: family/column not in column level access results cache. Access denied.");
            }
        } else if (this._familiesAccessAllowed.contains(family)) {
            LOG.debug("filterKeyValue: family found in access allowed families cache.  Must re-authorize for correct audit generation.");
            authCheckNeeded = true;
        } else if (this._familiesAccessIndeterminate.contains(family)) {
            LOG.debug("filterKeyValue: family found in indeterminate families cache.  Evaluating access...");
            authCheckNeeded = true;
        } else {
            LOG.warn("filterKeyValue: Unexpected - alien family encountered that wasn't seen by pre-hook!  Access Denied.!");
        }
        if (authCheckNeeded) {
            LOG.debug("filterKeyValue: Checking authorization...");
            this._session.columnFamily(family).column(column).buildRequest().authorize();
            AuthzAuditEvent auditEvent = this._auditHandler.getAndDiscardMostRecentEvent();
            if (this._session.isAuthorized()) {
                LOG.debug("filterKeyValue: Access granted.");
                result = Filter.ReturnCode.INCLUDE;
                if (auditEvent != null) {
                    LOG.debug("filterKeyValue: access is audited.");
                    this._auditHandler.logAuthzAudits(Collections.singletonList(auditEvent));
                } else {
                    LOG.debug("filterKeyValue: no audit event returned.  Access not audited.");
                }
            } else {
                LOG.debug("filterKeyValue: Access denied.  Denial not audited.");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filterKeyValue: " + result);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("familiesAccessAllowed", this._familiesAccessAllowed).add("familiesAccessDenied", this._familiesAccessDenied).add("familiesAccessUnknown", this._familiesAccessIndeterminate).add("columnsAccessAllowed", this._columnsAccessAllowed).toString();
    }
}

