/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsCryptoProvider
implements TlsCryptoProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private JcaJceHelper altHelper = null;

    public JcaTlsCryptoProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        this.altHelper = null;
        return this;
    }

    public JcaTlsCryptoProvider setAlternateProvider(Provider provider) {
        this.altHelper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaTlsCryptoProvider setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        this.altHelper = null;
        return this;
    }

    public JcaTlsCryptoProvider setAlternateProvider(String string) {
        this.altHelper = new NamedJcaJceHelper(string);
        return this;
    }

    @Override
    public JcaTlsCrypto create(SecureRandom secureRandom) {
        try {
            JcaJceHelper jcaJceHelper = this.getHelper();
            if (secureRandom == null) {
                secureRandom = jcaJceHelper instanceof DefaultJcaJceHelper ? SecureRandom.getInstance("DEFAULT") : SecureRandom.getInstance("DEFAULT", jcaJceHelper.createMessageDigest("SHA-512").getProvider());
            }
            return this.create(secureRandom, new NonceEntropySource(jcaJceHelper, secureRandom));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create JcaTlsCrypto: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public JcaTlsCrypto create(SecureRandom secureRandom, SecureRandom secureRandom2) {
        return new JcaTlsCrypto(this.getHelper(), this.getAltHelper(), secureRandom, secureRandom2);
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    public JcaJceHelper getAltHelper() {
        return this.altHelper;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class NonceEntropySource
    extends SecureRandom {
        NonceEntropySource(JcaJceHelper jcaJceHelper, SecureRandom secureRandom) throws GeneralSecurityException {
            super(new NonceEntropySourceSpi(secureRandom, jcaJceHelper.createMessageDigest("SHA-512")), secureRandom.getProvider());
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        private static class NonceEntropySourceSpi
        extends SecureRandomSpi {
            private final SecureRandom source;
            private final MessageDigest digest;
            private final byte[] seed;
            private final byte[] state;

            NonceEntropySourceSpi(SecureRandom secureRandom, MessageDigest messageDigest) {
                this.source = secureRandom;
                this.digest = messageDigest;
                this.seed = secureRandom.generateSeed(messageDigest.getDigestLength());
                this.state = new byte[this.seed.length];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineSetSeed(byte[] byArray) {
                MessageDigest messageDigest = this.digest;
                synchronized (messageDigest) {
                    this.runDigest(this.seed, byArray, this.seed);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineNextBytes(byte[] byArray) {
                MessageDigest messageDigest = this.digest;
                synchronized (messageDigest) {
                    int n = this.state.length;
                    for (int i = 0; i != byArray.length; ++i) {
                        if (n == this.state.length) {
                            this.source.nextBytes(this.state);
                            this.runDigest(this.seed, this.state, this.state);
                            n = 0;
                        }
                        byArray[i] = this.state[n++];
                    }
                }
            }

            @Override
            protected byte[] engineGenerateSeed(int n) {
                return this.source.generateSeed(n);
            }

            private void runDigest(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                this.digest.update(byArray);
                this.digest.update(byArray2);
                try {
                    this.digest.digest(byArray3, 0, byArray3.length);
                }
                catch (DigestException digestException) {
                    throw Exceptions.illegalStateException("unable to generate nonce data: " + digestException.getMessage(), digestException);
                }
            }
        }
    }
}

