/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoTileGroupSource
extends SingleGroupSource
implements ToXContentObject {
    private static final String NAME = "transform_geo_tile_group";
    private static final ParseField PRECISION = new ParseField("precision", new String[0]);
    private static final ConstructingObjectParser<GeoTileGroupSource, Void> PARSER = new ConstructingObjectParser("transform_geo_tile_group", true, args -> {
        String field = (String)args[0];
        boolean missingBucket = args[1] == null ? false : (Boolean)args[1];
        Integer precision = (Integer)args[2];
        GeoBoundingBox boundingBox = (GeoBoundingBox)args[3];
        return new GeoTileGroupSource(field, missingBucket, precision, boundingBox);
    });
    private final Integer precision;
    private final GeoBoundingBox geoBoundingBox;

    public GeoTileGroupSource(String field, Integer precision, GeoBoundingBox boundingBox) {
        this(field, false, precision, boundingBox);
    }

    public GeoTileGroupSource(String field, boolean missingBucket, Integer precision, GeoBoundingBox boundingBox) {
        super(field, null, missingBucket);
        if (precision != null) {
            GeoTileUtils.checkPrecisionRange((int)precision);
        }
        this.precision = precision;
        this.geoBoundingBox = boundingBox;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.GEOTILE_GRID;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public GeoBoundingBox getGeoBoundingBox() {
        return this.geoBoundingBox;
    }

    public static GeoTileGroupSource fromXContent(XContentParser parser) {
        return (GeoTileGroupSource)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        if (this.precision != null) {
            builder.field(PRECISION.getPreferredName(), this.precision);
        }
        if (this.geoBoundingBox != null) {
            builder.startObject(GeoBoundingBox.BOUNDS_FIELD.getPreferredName());
            this.geoBoundingBox.toXContentFragment(builder, true);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeoTileGroupSource that = (GeoTileGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.precision, that.precision) && Objects.equals(this.geoBoundingBox, that.geoBoundingBox);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.missingBucket, this.precision, this.geoBoundingBox);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MISSING_BUCKET);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), PRECISION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> GeoBoundingBox.parseBoundingBox((XContentParser)p), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
    }

    public static class Builder {
        private String field;
        private boolean missingBucket;
        private Integer precision;
        private GeoBoundingBox boundingBox;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setMissingBucket(boolean missingBucket) {
            this.missingBucket = missingBucket;
            return this;
        }

        public Builder setPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder setBoundingBox(GeoBoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public GeoTileGroupSource build() {
            return new GeoTileGroupSource(this.field, this.missingBucket, this.precision, this.boundingBox);
        }
    }
}

