/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class HighlightField
implements ToXContentFragment,
Writeable {
    private String name;
    private Text[] fragments;

    public HighlightField(StreamInput in) throws IOException {
        this.name = in.readString();
        if (in.readBoolean()) {
            int size = in.readVInt();
            if (size == 0) {
                this.fragments = Text.EMPTY_ARRAY;
            } else {
                this.fragments = new Text[size];
                for (int i = 0; i < size; ++i) {
                    this.fragments[i] = in.readText();
                }
            }
        }
    }

    public HighlightField(String name, Text[] fragments) {
        this.name = Objects.requireNonNull(name, "missing highlight field name");
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    public Text[] fragments() {
        return this.fragments;
    }

    public Text[] getFragments() {
        return this.fragments();
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fragments.length);
            for (Text fragment : this.fragments) {
                out.writeText(fragment);
            }
        }
    }

    public static HighlightField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String fieldName = parser.currentName();
        Text[] fragments = null;
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<Text> values = new ArrayList<Text>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                values.add(new Text(parser.text()));
            }
            fragments = values.toArray(new Text[values.size()]);
        } else if (token == XContentParser.Token.VALUE_NULL) {
            fragments = null;
        } else {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token type [" + token + "]", new Object[0]);
        }
        return new HighlightField(fieldName, fragments);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.name);
        if (this.fragments == null) {
            builder.nullValue();
        } else {
            builder.startArray();
            for (Text fragment : this.fragments) {
                builder.value((Object)fragment);
            }
            builder.endArray();
        }
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightField other = (HighlightField)obj;
        return Objects.equals(this.name, other.name) && Arrays.equals(this.fragments, other.fragments);
    }

    public final int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.fragments));
    }
}

