/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.RejectAwareActionListener;
import org.elasticsearch.index.reindex.RetryListener;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class ScrollableHitSource {
    private final AtomicReference<String> scrollId = new AtomicReference();
    protected final Logger logger;
    protected final BackoffPolicy backoffPolicy;
    protected final ThreadPool threadPool;
    protected final Runnable countSearchRetry;
    private final Consumer<AsyncResponse> onResponse;
    protected final Consumer<Exception> fail;

    public ScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<AsyncResponse> onResponse, Consumer<Exception> fail) {
        this.logger = logger;
        this.backoffPolicy = backoffPolicy;
        this.threadPool = threadPool;
        this.countSearchRetry = countSearchRetry;
        this.onResponse = onResponse;
        this.fail = fail;
    }

    public final void start() {
        this.doStart(this.createRetryListener(this::doStart));
    }

    private RetryListener createRetryListener(Consumer<RejectAwareActionListener<Response>> retryHandler) {
        Consumer<RejectAwareActionListener<Response>> countingRetryHandler = listener -> {
            this.countSearchRetry.run();
            retryHandler.accept((RejectAwareActionListener<Response>)listener);
        };
        return new RetryListener(this.logger, this.threadPool, this.backoffPolicy, countingRetryHandler, ActionListener.wrap(this::onResponse, this.fail));
    }

    public final void startNextScroll(TimeValue extraKeepAlive) {
        this.startNextScroll(extraKeepAlive, this.createRetryListener(listener -> this.startNextScroll(extraKeepAlive, (RejectAwareActionListener<Response>)listener)));
    }

    private void startNextScroll(TimeValue extraKeepAlive, RejectAwareActionListener<Response> searchListener) {
        this.doStartNextScroll(this.scrollId.get(), extraKeepAlive, searchListener);
    }

    private void onResponse(final Response response) {
        this.logger.trace("scroll returned [{}] documents with a scroll id of [{}]", (Object)response.getHits().size(), (Object)response.getScrollId());
        this.setScroll(response.getScrollId());
        this.onResponse.accept(new AsyncResponse(){
            private AtomicBoolean alreadyDone = new AtomicBoolean();

            @Override
            public Response response() {
                return response;
            }

            @Override
            public void done(TimeValue extraKeepAlive) {
                assert (this.alreadyDone.compareAndSet(false, true));
                ScrollableHitSource.this.startNextScroll(extraKeepAlive);
            }
        });
    }

    public final void close(Runnable onCompletion) {
        String scrollId = this.scrollId.get();
        if (Strings.hasLength(scrollId)) {
            this.clearScroll(scrollId, () -> this.cleanup(onCompletion));
        } else {
            this.cleanup(onCompletion);
        }
    }

    protected abstract void doStart(RejectAwareActionListener<Response> var1);

    protected abstract void doStartNextScroll(String var1, TimeValue var2, RejectAwareActionListener<Response> var3);

    protected abstract void clearScroll(String var1, Runnable var2);

    protected abstract void cleanup(Runnable var1);

    public final void setScroll(String scrollId) {
        this.scrollId.set(scrollId);
    }

    public static class Response {
        private final boolean timedOut;
        private final List<SearchFailure> failures;
        private final long totalHits;
        private final List<? extends Hit> hits;
        private final String scrollId;

        public Response(boolean timedOut, List<SearchFailure> failures, long totalHits, List<? extends Hit> hits, String scrollId) {
            this.timedOut = timedOut;
            this.failures = failures;
            this.totalHits = totalHits;
            this.hits = hits;
            this.scrollId = scrollId;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public final List<SearchFailure> getFailures() {
            return this.failures;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public List<? extends Hit> getHits() {
            return this.hits;
        }

        public String getScrollId() {
            return this.scrollId;
        }
    }

    public static class SearchFailure
    implements Writeable,
    ToXContentObject {
        private final Throwable reason;
        private final RestStatus status;
        @Nullable
        private final String index;
        @Nullable
        private final Integer shardId;
        @Nullable
        private final String nodeId;
        public static final String INDEX_FIELD = "index";
        public static final String SHARD_FIELD = "shard";
        public static final String NODE_FIELD = "node";
        public static final String REASON_FIELD = "reason";
        public static final String STATUS_FIELD = "status";

        public SearchFailure(Throwable reason, @Nullable String index, @Nullable Integer shardId, @Nullable String nodeId) {
            this(reason, index, shardId, nodeId, ExceptionsHelper.status(reason));
        }

        public SearchFailure(Throwable reason, @Nullable String index, @Nullable Integer shardId, @Nullable String nodeId, RestStatus status) {
            this.index = index;
            this.shardId = shardId;
            this.reason = Objects.requireNonNull(reason, "reason cannot be null");
            this.nodeId = nodeId;
            this.status = status;
        }

        public SearchFailure(Throwable reason) {
            this(reason, null, null, null);
        }

        public SearchFailure(StreamInput in) throws IOException {
            this.reason = in.readException();
            this.index = in.readOptionalString();
            this.shardId = in.readOptionalVInt();
            this.nodeId = in.readOptionalString();
            this.status = ExceptionsHelper.status(this.reason);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeException(this.reason);
            out.writeOptionalString(this.index);
            out.writeOptionalVInt(this.shardId);
            out.writeOptionalString(this.nodeId);
        }

        public String getIndex() {
            return this.index;
        }

        public Integer getShardId() {
            return this.shardId;
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Throwable getReason() {
            return this.reason;
        }

        @Nullable
        public String getNodeId() {
            return this.nodeId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field(INDEX_FIELD, this.index);
            }
            if (this.shardId != null) {
                builder.field(SHARD_FIELD, this.shardId);
            }
            if (this.nodeId != null) {
                builder.field(NODE_FIELD, this.nodeId);
            }
            builder.field(STATUS_FIELD, this.status.getStatus());
            builder.field(REASON_FIELD);
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class BasicHit
    implements Hit {
        private final String index;
        private final String type;
        private final String id;
        private final long version;
        private BytesReference source;
        private XContentType xContentType;
        private String routing;
        private long seqNo;
        private long primaryTerm;

        public BasicHit(String index, String type, String id, long version) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.version = version;
        }

        @Override
        public String getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getSeqNo() {
            return this.seqNo;
        }

        @Override
        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        @Override
        public BytesReference getSource() {
            return this.source;
        }

        @Override
        public XContentType getXContentType() {
            return this.xContentType;
        }

        public BasicHit setSource(BytesReference source, XContentType xContentType) {
            this.source = source;
            this.xContentType = xContentType;
            return this;
        }

        @Override
        public String getRouting() {
            return this.routing;
        }

        public BasicHit setRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public void setSeqNo(long seqNo) {
            this.seqNo = seqNo;
        }

        public void setPrimaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
        }
    }

    public static interface Hit {
        public String getIndex();

        public String getType();

        public String getId();

        public long getVersion();

        public long getSeqNo();

        public long getPrimaryTerm();

        @Nullable
        public BytesReference getSource();

        @Nullable
        public XContentType getXContentType();

        @Nullable
        public String getRouting();
    }

    public static interface AsyncResponse {
        public Response response();

        public void done(TimeValue var1);
    }
}

