/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.security.Provider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BouncyCastleProviderFactory.class);
    private static final String FIPS_PROVIDER = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String GENERAL_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static Provider getBouncyCastleProvider() {
        for (String providerClass : new String[]{FIPS_PROVIDER, GENERAL_PROVIDER}) {
            Optional<Class<?>> provider = BouncyCastleProviderFactory.findProvider(providerClass);
            if (provider.isPresent()) {
                LOG.debug("Using BouncyCastle provider: {}", (Object)providerClass);
                return BouncyCastleProviderFactory.initializeProvider(provider.get());
            }
            LOG.debug("Provider not found: {}", (Object)providerClass);
        }
        throw new IllegalStateException("Neither BouncyCastleFipsProvider nor BouncyCastleProvider was found on the classpath.");
    }

    private static Provider initializeProvider(Class<?> providerClass) {
        try {
            return (Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(providerClass.getName() + " cannot be instantiated.", ex);
        }
    }

    private static Optional<Class<?>> findProvider(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

