/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.XContentParser;

public final class WatchStatusDateParser {
    private static final DateFormatter FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;

    private WatchStatusDateParser() {
    }

    public static ZonedDateTime parseDate(String fieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return Instant.ofEpochMilli(parser.longValue()).atZone(ZoneOffset.UTC);
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            ZonedDateTime dateTime = WatchStatusDateParser.parseDate(parser.text());
            return dateTime.withZoneSameInstant(ZoneOffset.UTC);
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        throw new ElasticsearchParseException("could not parse date/time. expected date field [{}] to be either a number or a string but found [{}] instead", new Object[]{fieldName, token});
    }

    public static ZonedDateTime parseDate(String text) {
        return DateFormatters.from((TemporalAccessor)FORMATTER.parse(text));
    }
}

