/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeEngine
implements MultiBlockCipher {
    protected NativeReference wrapper = null;
    private int keyLen = 0;

    AESNativeEngine() {
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeEngine aESNativeEngine = this;
        synchronized (aESNativeEngine) {
            if (cipherParameters instanceof KeyParameter) {
                byte[] byArray = ((KeyParameter)cipherParameters).getKey();
                switch (byArray.length) {
                    case 16: 
                    case 24: 
                    case 32: {
                        this.wrapper = new ECBNativeRef(AESNativeEngine.makeNative(byArray.length, bl));
                        this.keyLen = byArray.length * 8;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("key must be 16, 24 or 32 bytes");
                    }
                }
                AESNativeEngine.init(this.wrapper.getReference(), byArray);
                return;
            }
            throw new IllegalArgumentException("invalid parameter passed to AES init - " + cipherParameters.getClass().getName());
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return AESNativeEngine.getBlockSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        AESNativeEngine aESNativeEngine = this;
        synchronized (aESNativeEngine) {
            if (this.wrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeEngine.process(this.wrapper.getReference(), byArray, n, 1, byArray2, n2);
        }
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeEngine.getMultiBlockSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        AESNativeEngine aESNativeEngine = this;
        synchronized (aESNativeEngine) {
            if (this.wrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeEngine.process(this.wrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeEngine aESNativeEngine = this;
        synchronized (aESNativeEngine) {
            if (this.wrapper == null) {
                return;
            }
            AESNativeEngine.reset(this.wrapper.getReference());
        }
    }

    private static native void reset(long var0);

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeNative(int var0, boolean var1);

    static native void dispose(long var0);

    static native void init(long var0, byte[] var2);

    public String toString() {
        return "AES[Native](" + this.keyLen + ")";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ECBNativeRef
    extends NativeReference {
        public ECBNativeRef(long l) {
            super(l);
        }

        @Override
        protected Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeEngine.dispose(l);
        }
    }
}

