/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.LdapUtils;
import org.apache.hive.service.auth.ldap.Query;
import org.apache.hive.service.auth.ldap.QueryFactory;
import org.apache.hive.service.auth.ldap.SearchResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapSearch
implements DirSearch {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSearch.class);
    private final String baseDn;
    private final List<String> groupBases;
    private final List<String> userBases;
    private final List<String> userPatterns;
    private final QueryFactory queries;
    private final DirContext ctx;

    public LdapSearch(HiveConf conf, DirContext ctx) throws NamingException {
        this.baseDn = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN);
        this.userPatterns = LdapUtils.parseDnPatterns(conf, HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN);
        this.groupBases = LdapUtils.patternsToBaseDns(LdapUtils.parseDnPatterns(conf, HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN));
        this.userBases = LdapUtils.patternsToBaseDns(this.userPatterns);
        this.ctx = ctx;
        this.queries = new QueryFactory(conf);
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            LOG.warn("Exception when closing LDAP context:", (Throwable)e);
        }
    }

    @Override
    public String findUserDn(String user) throws NamingException {
        List<String> allLdapNames;
        if (LdapUtils.isDn(user)) {
            String userBaseDn = LdapUtils.extractBaseDn(user);
            String userRdn = LdapUtils.extractFirstRdn(user);
            allLdapNames = this.execute(Collections.singletonList(userBaseDn), this.queries.findUserDnByRdn(userRdn)).getAllLdapNames();
        } else {
            allLdapNames = this.findDnByPattern(this.userPatterns, user);
            if (allLdapNames.isEmpty()) {
                allLdapNames = this.execute(this.userBases, this.queries.findUserDnByName(user)).getAllLdapNames();
            }
        }
        if (allLdapNames.size() == 1) {
            return allLdapNames.get(0);
        }
        LOG.info("Expected exactly one user result for the user: {}, but got {}. Returning null", (Object)user, (Object)allLdapNames.size());
        LOG.debug("Matched users: {}", allLdapNames);
        return null;
    }

    private List<String> findDnByPattern(List<String> patterns, String name) throws NamingException {
        for (String pattern : patterns) {
            String baseDnFromPattern = LdapUtils.extractBaseDn(pattern);
            String rdn = LdapUtils.extractFirstRdn(pattern).replaceAll("%s", name);
            List<String> list = this.execute(Collections.singletonList(baseDnFromPattern), this.queries.findDnByPattern(rdn)).getAllLdapNames();
            if (list.isEmpty()) continue;
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public String findGroupDn(String group) throws NamingException {
        return this.execute(this.groupBases, this.queries.findGroupDnById(group)).getSingleLdapName();
    }

    @Override
    public boolean isUserMemberOfGroup(String user, String groupDn) throws NamingException {
        String userId = LdapUtils.extractUserName(user);
        return this.execute(this.userBases, this.queries.isUserMemberOfGroup(userId, groupDn)).hasSingleResult();
    }

    @Override
    public List<String> findGroupsForUser(String userDn) throws NamingException {
        String userName = LdapUtils.extractUserName(userDn);
        return this.execute(this.groupBases, this.queries.findGroupsForUser(userName, userDn)).getAllLdapNames();
    }

    @Override
    public List<String> executeCustomQuery(String query) throws NamingException {
        return this.execute(Collections.singletonList(this.baseDn), this.queries.customQuery(query)).getAllLdapNamesAndAttributes();
    }

    private SearchResultHandler execute(Collection<String> baseDns, Query query) {
        ArrayList<NamingEnumeration<SearchResult>> searchResults = new ArrayList<NamingEnumeration<SearchResult>>();
        LOG.debug("Executing a query: '{}' with base DNs {}.", (Object)query.getFilter(), baseDns);
        for (String aBaseDn : baseDns) {
            try {
                NamingEnumeration<SearchResult> searchResult = this.ctx.search(aBaseDn, query.getFilter(), query.getControls());
                if (searchResult == null) continue;
                searchResults.add(searchResult);
            }
            catch (NamingException ex) {
                LOG.debug("Exception happened for query '" + query.getFilter() + "' with base DN '" + aBaseDn + "'", (Throwable)ex);
            }
        }
        return new SearchResultHandler(searchResults);
    }
}

