/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SignatureAndHashAlgorithm {
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP256r1tls13_sha256 = SignatureAndHashAlgorithm.create(2074);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP384r1tls13_sha384 = SignatureAndHashAlgorithm.create(2075);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP512r1tls13_sha512 = SignatureAndHashAlgorithm.create(2076);
    public static final SignatureAndHashAlgorithm ed25519 = SignatureAndHashAlgorithm.create(2055);
    public static final SignatureAndHashAlgorithm ed448 = SignatureAndHashAlgorithm.create(2056);
    public static final SignatureAndHashAlgorithm gostr34102012_256 = SignatureAndHashAlgorithm.create((short)8, (short)64);
    public static final SignatureAndHashAlgorithm gostr34102012_512 = SignatureAndHashAlgorithm.create((short)8, (short)65);
    public static final SignatureAndHashAlgorithm mldsa44 = SignatureAndHashAlgorithm.create(2308);
    public static final SignatureAndHashAlgorithm mldsa65 = SignatureAndHashAlgorithm.create(2309);
    public static final SignatureAndHashAlgorithm mldsa87 = SignatureAndHashAlgorithm.create(2310);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha256 = SignatureAndHashAlgorithm.create(2052);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha384 = SignatureAndHashAlgorithm.create(2053);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha512 = SignatureAndHashAlgorithm.create(2054);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha256 = SignatureAndHashAlgorithm.create(2057);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha384 = SignatureAndHashAlgorithm.create(2058);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha512 = SignatureAndHashAlgorithm.create(2059);
    protected final short hash;
    protected final short signature;

    public static SignatureAndHashAlgorithm getInstance(short s, short s2) {
        switch (s) {
            case 8: {
                return SignatureAndHashAlgorithm.getInstanceIntrinsic(s2);
            }
        }
        return SignatureAndHashAlgorithm.create(s, s2);
    }

    private static SignatureAndHashAlgorithm getInstanceIntrinsic(short s) {
        switch (s) {
            case 7: {
                return ed25519;
            }
            case 8: {
                return ed448;
            }
            case 64: {
                return gostr34102012_256;
            }
            case 65: {
                return gostr34102012_512;
            }
            case 4: {
                return rsa_pss_rsae_sha256;
            }
            case 5: {
                return rsa_pss_rsae_sha384;
            }
            case 6: {
                return rsa_pss_rsae_sha512;
            }
            case 9: {
                return rsa_pss_pss_sha256;
            }
            case 10: {
                return rsa_pss_pss_sha384;
            }
            case 11: {
                return rsa_pss_pss_sha512;
            }
            case 26: {
                return ecdsa_brainpoolP256r1tls13_sha256;
            }
            case 27: {
                return ecdsa_brainpoolP384r1tls13_sha384;
            }
            case 28: {
                return ecdsa_brainpoolP512r1tls13_sha512;
            }
        }
        return SignatureAndHashAlgorithm.create((short)8, s);
    }

    private static SignatureAndHashAlgorithm create(int n) {
        short s = SignatureScheme.getHashAlgorithm(n);
        short s2 = SignatureScheme.getSignatureAlgorithm(n);
        return SignatureAndHashAlgorithm.create(s, s2);
    }

    private static SignatureAndHashAlgorithm create(short s, short s2) {
        return new SignatureAndHashAlgorithm(s, s2);
    }

    public SignatureAndHashAlgorithm(short s, short s2) {
        if ((s & 0xFF) != s) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if ((s2 & 0xFF) != s2) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        this.hash = s;
        this.signature = s2;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.getHash(), outputStream);
        TlsUtils.writeUint8(this.getSignature(), outputStream);
    }

    public static SignatureAndHashAlgorithm parse(InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        short s2 = TlsUtils.readUint8(inputStream);
        return SignatureAndHashAlgorithm.getInstance(s, s2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)object;
        return signatureAndHashAlgorithm.getHash() == this.getHash() && signatureAndHashAlgorithm.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public String toString() {
        return "{" + HashAlgorithm.getText(this.hash) + "," + SignatureAlgorithm.getText(this.signature) + "}";
    }
}

