/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.client.JsonCodec;
import io.trino.jdbc.$internal.client.NamedClientTypeSignature;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.trino.jdbc.$internal.jackson.databind.JsonNode;
import io.trino.jdbc.$internal.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

@.JsonDeserialize(using=ClientTypeSignatureParameterDeserializer.class)
@.Immutable
public class ClientTypeSignatureParameter {
    private final ParameterKind kind;
    private final Object value;

    public static ClientTypeSignatureParameter ofType(ClientTypeSignature typeSignature) {
        return new ClientTypeSignatureParameter(ParameterKind.TYPE, typeSignature);
    }

    public static ClientTypeSignatureParameter ofNamedType(NamedClientTypeSignature namedTypeSignature) {
        return new ClientTypeSignatureParameter(ParameterKind.NAMED_TYPE, namedTypeSignature);
    }

    public static ClientTypeSignatureParameter ofLong(long longLiteral) {
        return new ClientTypeSignatureParameter(ParameterKind.LONG, longLiteral);
    }

    @.JsonCreator
    public ClientTypeSignatureParameter(@.JsonProperty(value="kind") ParameterKind kind, @.JsonProperty(value="value") Object value) {
        this.kind = kind;
        this.value = value;
    }

    @.JsonProperty
    public ParameterKind getKind() {
        return this.kind;
    }

    @.JsonProperty
    public Object getValue() {
        return this.value;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(this.value);
    }

    public ClientTypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, ClientTypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedClientTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedClientTypeSignature.class);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignatureParameter other = (ClientTypeSignatureParameter)o;
        return this.kind == other.kind && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }

    public static class ClientTypeSignatureParameterDeserializer
    extends JsonDeserializer<ClientTypeSignatureParameter> {
        private static final ObjectMapper MAPPER = JsonCodec.OBJECT_MAPPER_SUPPLIER.get();

        @Override
        public ClientTypeSignatureParameter deserialize(JsonParser jp, .DeserializationContext ctxt) throws IOException {
            Object value;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            ParameterKind kind = MAPPER.readValue(MAPPER.treeAsTokens(node.get("kind")), ParameterKind.class);
            JsonParser jsonValue = MAPPER.treeAsTokens(node.get("value"));
            switch (kind) {
                case TYPE: {
                    value = MAPPER.readValue(jsonValue, ClientTypeSignature.class);
                    break;
                }
                case NAMED_TYPE: {
                    value = MAPPER.readValue(jsonValue, NamedClientTypeSignature.class);
                    break;
                }
                case LONG: {
                    value = MAPPER.readValue(jsonValue, Long.class);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported kind [%s]", new Object[]{kind}));
                }
            }
            return new ClientTypeSignatureParameter(kind, value);
        }
    }

    public static enum ParameterKind {
        TYPE,
        NAMED_TYPE,
        LONG,
        VARIABLE;


        @.JsonCreator
        public static ParameterKind fromJsonValue(String value) {
            switch (value) {
                case "TYPE_SIGNATURE": {
                    return TYPE;
                }
                case "NAMED_TYPE_SIGNATURE": {
                    return NAMED_TYPE;
                }
                case "LONG_LITERAL": {
                    return LONG;
                }
            }
            return ParameterKind.valueOf(value);
        }
    }
}

