/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import java.util.Objects;

public final class LongTimestamp {
    private static final int PICOSECONDS_PER_MICROSECOND = 1000000;
    private final long epochMicros;
    private final int picosOfMicro;

    public LongTimestamp(long epochMicros, int picosOfMicro) {
        if (picosOfMicro < 0) {
            throw new IllegalArgumentException("picosOfMicro must be >= 0");
        }
        if (picosOfMicro >= 1000000) {
            throw new IllegalArgumentException("picosOfMicro must be < 1_000_000");
        }
        this.epochMicros = epochMicros;
        this.picosOfMicro = picosOfMicro;
    }

    public long getEpochMicros() {
        return this.epochMicros;
    }

    public int getPicosOfMicro() {
        return this.picosOfMicro;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongTimestamp that = (LongTimestamp)o;
        return this.epochMicros == that.epochMicros && this.picosOfMicro == that.picosOfMicro;
    }

    public int hashCode() {
        return Objects.hash(this.epochMicros, this.picosOfMicro);
    }
}

