/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jose.jws;

import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;

public enum SignatureAlgorithm implements JwsAlgorithm
{
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512");

    private final String name;

    private SignatureAlgorithm(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SignatureAlgorithm from(String name) {
        for (SignatureAlgorithm value : SignatureAlgorithm.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }
}

