/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.PutToByteBuffer;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufInputStream;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.ratis.thirdparty.io.netty.buffer.EmptyByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecBuffer
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(CodecBuffer.class);
    private static final ByteBufAllocator POOL = PooledByteBufAllocator.DEFAULT;
    private static final IntFunction<ByteBuf> POOL_DIRECT = c -> c >= 0 ? POOL.directBuffer(c, c) : POOL.directBuffer(-c);
    private static final IntFunction<ByteBuf> POOL_HEAP = c -> c >= 0 ? POOL.heapBuffer(c, c) : POOL.heapBuffer(-c);
    private static final CodecBuffer EMPTY_BUFFER = new CodecBuffer((ByteBuf)new EmptyByteBuf(POOL), null);
    private final StackTraceElement[] elements;
    private static final AtomicInteger LEAK_COUNT = new AtomicInteger();
    private final ByteBuf buf;
    private final Object wrapped;
    private final CompletableFuture<Void> released = new CompletableFuture();

    public static void enableLeakDetection() {
        Factory.set(LeakDetector::newCodecBuffer);
    }

    public static CodecBuffer getEmptyBuffer() {
        return EMPTY_BUFFER;
    }

    static CodecBuffer allocate(int capacity, IntFunction<ByteBuf> allocator) {
        return Factory.newCodecBuffer(allocator.apply(capacity));
    }

    public static CodecBuffer allocateDirect(int capacity) {
        return CodecBuffer.allocate(capacity, POOL_DIRECT);
    }

    public static CodecBuffer allocateHeap(int capacity) {
        return CodecBuffer.allocate(capacity, POOL_HEAP);
    }

    public static CodecBuffer wrap(byte[] array) {
        return Factory.newCodecBuffer(Unpooled.wrappedBuffer((byte[])array), array);
    }

    public static CodecBuffer wrap(ByteString bytes) {
        return Factory.newCodecBuffer(Unpooled.wrappedBuffer((ByteBuffer)bytes.asReadOnlyByteBuffer()), bytes);
    }

    public static void assertNoLeaks() {
        long leak = LEAK_COUNT.get();
        if (leak > 0L) {
            throw new AssertionError((Object)("Found " + leak + " leaked objects, check logs"));
        }
    }

    private CodecBuffer(ByteBuf buf, Object wrapped) {
        this.buf = buf;
        this.wrapped = wrapped;
        this.elements = HddsUtils.getStackTrace(LOG);
        this.assertRefCnt(1);
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public Object getWrapped() {
        return this.wrapped;
    }

    private void assertRefCnt(int expected) {
        Preconditions.assertSame((int)expected, (int)this.buf.refCnt(), (String)"refCnt");
    }

    void detectLeaks() {
        int refCnt;
        int capacity = this.buf.capacity();
        if (!this.released.isDone() && capacity > 0 && (refCnt = this.buf.refCnt()) > 0) {
            int leak = LEAK_COUNT.incrementAndGet();
            LOG.warn("LEAK {}: {}, refCnt={}, capacity={}{}", new Object[]{leak, this, refCnt, capacity, this.elements != null ? " allocation:\n" + HddsUtils.formatStackTrace(this.elements, 3) : ""});
            this.buf.release(refCnt);
        }
    }

    @Override
    public void close() {
        this.release();
    }

    public void release() {
        boolean set = this.released.complete(null);
        if (!set) {
            Preconditions.assertSame((int)0, (int)this.buf.capacity(), (String)"capacity");
        }
        if (this.buf.release()) {
            this.assertRefCnt(0);
        } else {
            Preconditions.assertSame((int)0, (int)this.buf.capacity(), (String)"capacity");
        }
    }

    public CompletableFuture<Void> getReleaseFuture() {
        return this.released;
    }

    public void clear() {
        this.buf.clear();
    }

    public boolean setCapacity(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("newCapacity = " + newCapacity + " < 0");
        }
        LOG.debug("setCapacity: {} -> {}, max={}", new Object[]{this.buf.capacity(), newCapacity, this.buf.maxCapacity()});
        if (newCapacity <= this.buf.maxCapacity()) {
            ByteBuf returned = this.buf.capacity(newCapacity);
            Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
            return true;
        }
        return false;
    }

    public int readableBytes() {
        return this.buf.readableBytes();
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        this.assertRefCnt(1);
        Preconditions.assertTrue((this.buf.nioBufferCount() > 0 ? 1 : 0) != 0);
        return this.buf.nioBuffer().asReadOnlyBuffer();
    }

    public byte[] getArray() {
        byte[] array = new byte[this.readableBytes()];
        this.buf.readBytes(array);
        return array;
    }

    public boolean startsWith(CodecBuffer prefix) {
        Objects.requireNonNull(prefix, "prefix == null");
        int length = prefix.readableBytes();
        if (this.readableBytes() < length) {
            return false;
        }
        return this.buf.slice(this.buf.readerIndex(), length).equals((Object)prefix.buf);
    }

    public InputStream getInputStream() {
        return new ByteBufInputStream(this.buf.duplicate());
    }

    public CodecBuffer putShort(short n) {
        this.assertRefCnt(1);
        ByteBuf returned = this.buf.writeShort((int)n);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    public CodecBuffer putInt(int n) {
        this.assertRefCnt(1);
        ByteBuf returned = this.buf.writeInt(n);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    public CodecBuffer putLong(long n) {
        this.assertRefCnt(1);
        ByteBuf returned = this.buf.writeLong(n);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    public CodecBuffer put(byte val) {
        this.assertRefCnt(1);
        ByteBuf returned = this.buf.writeByte((int)val);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    public CodecBuffer put(byte[] array) {
        this.assertRefCnt(1);
        this.buf.writeBytes(array);
        return this;
    }

    public CodecBuffer put(ByteBuffer buffer) {
        this.assertRefCnt(1);
        this.buf.writeBytes(buffer);
        return this;
    }

    CodecBuffer put(ToIntFunction<ByteBuffer> source) {
        this.assertRefCnt(1);
        int w = this.buf.writerIndex();
        ByteBuffer buffer = this.buf.nioBuffer(w, this.buf.writableBytes());
        int size = source.applyAsInt(buffer);
        ByteBuf returned = this.buf.setIndex(this.buf.readerIndex(), w + size);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    public CodecBuffer put(CheckedFunction<OutputStream, Integer, IOException> source) throws IOException {
        int size;
        this.assertRefCnt(1);
        int w = this.buf.writerIndex();
        try (ByteBufOutputStream out = new ByteBufOutputStream(this.buf);){
            size = (Integer)source.apply((Object)out);
        }
        ByteBuf returned = this.buf.setIndex(this.buf.readerIndex(), w + size);
        Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
        return this;
    }

    <E extends Exception> Integer putFromSource(PutToByteBuffer<E> source) throws E {
        this.assertRefCnt(1);
        int i = this.buf.writerIndex();
        int writable = this.buf.writableBytes();
        ByteBuffer buffer = this.buf.nioBuffer(i, writable);
        Integer size = (Integer)source.apply(buffer);
        if (size != null) {
            Preconditions.assertTrue((size >= 0 ? 1 : 0) != 0, () -> "size = " + size + " < 0");
            if (size > 0 && size <= writable) {
                ByteBuf returned = this.buf.setIndex(this.buf.readerIndex(), i + size);
                Preconditions.assertSame((Object)this.buf, (Object)returned, (String)"buf");
            }
        }
        return size;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.buf.readerIndex() + "<=" + this.buf.writerIndex() + "<=" + this.buf.capacity() + ": " + StringUtils.bytes2Hex(this.asReadOnlyByteBuffer(), 10) + "]";
    }

    public static interface Allocator
    extends IntFunction<CodecBuffer> {
        public static final Allocator DIRECT = new Allocator(){

            @Override
            public CodecBuffer apply(int capacity) {
                return CodecBuffer.allocate(capacity, POOL_DIRECT);
            }

            @Override
            public boolean isDirect() {
                return true;
            }
        };
        public static final Allocator HEAP = new Allocator(){

            @Override
            public CodecBuffer apply(int capacity) {
                return CodecBuffer.allocate(capacity, POOL_HEAP);
            }

            @Override
            public boolean isDirect() {
                return false;
            }
        };

        public static Allocator getDirect() {
            return DIRECT;
        }

        public static Allocator getHeap() {
            return HEAP;
        }

        public boolean isDirect();
    }

    public static class Capacity {
        private final Object name;
        private final AtomicInteger value;

        public Capacity(Object name, int initialCapacity) {
            this.name = name;
            this.value = new AtomicInteger(initialCapacity);
        }

        public int get() {
            return this.value.get();
        }

        private static int nextValue(int n) {
            long roundUp = Long.highestOneBit(n) << 1;
            return roundUp > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)roundUp;
        }

        public void increase(int required) {
            MemoizedSupplier newBufferSize = MemoizedSupplier.valueOf(() -> Capacity.nextValue(required));
            int previous = this.value.getAndUpdate(current -> required <= current ? current : (Integer)newBufferSize.get());
            if (newBufferSize.isInitialized()) {
                LOG.info("{}: increase {} -> {}", new Object[]{this.name, previous, newBufferSize.get()});
            }
        }
    }

    private static class LeakDetector {
        private LeakDetector() {
        }

        static CodecBuffer newCodecBuffer(ByteBuf buf, Object wrapped) {
            return new CodecBuffer(buf, wrapped){

                protected void finalize() {
                    this.detectLeaks();
                }
            };
        }
    }

    private static class Factory {
        private static volatile BiFunction<ByteBuf, Object, CodecBuffer> constructor = (x$0, x$1) -> new CodecBuffer((ByteBuf)x$0, x$1);

        private Factory() {
        }

        static void set(BiFunction<ByteBuf, Object, CodecBuffer> f) {
            constructor = f;
            LOG.info("Successfully set constructor to " + f);
        }

        static CodecBuffer newCodecBuffer(ByteBuf buf) {
            return Factory.newCodecBuffer(buf, null);
        }

        static CodecBuffer newCodecBuffer(ByteBuf buf, Object wrapped) {
            return constructor.apply(buf, wrapped);
        }
    }
}

