/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.client.transform.transforms.TransformProgress;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class TransformCheckpointStats {
    public static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    public static final ParseField POSITION = new ParseField("position", new String[0]);
    public static final ParseField CHECKPOINT_PROGRESS = new ParseField("checkpoint_progress", new String[0]);
    public static final ParseField TIMESTAMP_MILLIS = new ParseField("timestamp_millis", new String[0]);
    public static final ParseField TIME_UPPER_BOUND_MILLIS = new ParseField("time_upper_bound_millis", new String[0]);
    public static final TransformCheckpointStats EMPTY = new TransformCheckpointStats(0L, null, null, 0L, 0L);
    private final long checkpoint;
    private final TransformIndexerPosition position;
    private final TransformProgress checkpointProgress;
    private final long timestampMillis;
    private final long timeUpperBoundMillis;
    public static final ConstructingObjectParser<TransformCheckpointStats, Void> LENIENT_PARSER = new ConstructingObjectParser("transform_checkpoint_stats", true, args -> {
        long checkpoint = args[0] == null ? 0L : (Long)args[0];
        TransformIndexerPosition position = (TransformIndexerPosition)args[1];
        TransformProgress checkpointProgress = (TransformProgress)args[2];
        long timestamp = args[3] == null ? 0L : (Long)args[3];
        long timeUpperBound = args[4] == null ? 0L : (Long)args[4];
        return new TransformCheckpointStats(checkpoint, position, checkpointProgress, timestamp, timeUpperBound);
    });

    public static TransformCheckpointStats fromXContent(XContentParser parser) throws IOException {
        return (TransformCheckpointStats)LENIENT_PARSER.parse(parser, null);
    }

    public TransformCheckpointStats(long checkpoint, TransformIndexerPosition position, TransformProgress checkpointProgress, long timestampMillis, long timeUpperBoundMillis) {
        this.checkpoint = checkpoint;
        this.position = position;
        this.checkpointProgress = checkpointProgress;
        this.timestampMillis = timestampMillis;
        this.timeUpperBoundMillis = timeUpperBoundMillis;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public TransformIndexerPosition getPosition() {
        return this.position;
    }

    public TransformProgress getCheckpointProgress() {
        return this.checkpointProgress;
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public long getTimeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    public int hashCode() {
        return Objects.hash(this.checkpoint, this.position, this.checkpointProgress, this.timestampMillis, this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformCheckpointStats that = (TransformCheckpointStats)other;
        return this.checkpoint == that.checkpoint && Objects.equals(this.position, that.position) && Objects.equals(this.checkpointProgress, that.checkpointProgress) && this.timestampMillis == that.timestampMillis && this.timeUpperBoundMillis == that.timeUpperBoundMillis;
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TransformIndexerPosition.PARSER, POSITION);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TransformProgress.PARSER, CHECKPOINT_PROGRESS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIMESTAMP_MILLIS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_UPPER_BOUND_MILLIS);
    }
}

