/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.ensemble.OutputAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class LogisticRegression
implements OutputAggregator {
    public static final String NAME = "logistic_regression";
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<LogisticRegression, Void> PARSER = new ConstructingObjectParser("logistic_regression", true, a -> new LogisticRegression((List)a[0]));
    private final List<Double> weights;

    public static LogisticRegression fromXContent(XContentParser parser) {
        return (LogisticRegression)PARSER.apply(parser, null);
    }

    public LogisticRegression(List<Double> weights) {
        this.weights = weights;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogisticRegression that = (LogisticRegression)o;
        return Objects.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
    }
}

