/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Utils {
    private static Charset UTF8 = Charset.forName("UTF-8");

    Utils() {
    }

    static byte[] toUTF8(String string) {
        return string.getBytes(UTF8);
    }

    static String fromUTF8(byte[] bytes) {
        return new String(bytes, UTF8);
    }

    static <K, V> Map<K, V[]> unfold(Map<K, List<V>> map, Class<V> listElementType) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, Object[]> result = new HashMap<K, Object[]>();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            Object[] array = (Object[])Array.newInstance(listElementType, entry.getValue().size());
            result.put(entry.getKey(), entry.getValue().toArray(array));
        }
        return result;
    }

    static <T> List<T> listOfCapacity(int capacity) {
        return capacity > 0 ? new ArrayList(capacity) : Collections.emptyList();
    }
}

