/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.validation.ConstraintViolation;
import javax.validation.ParameterNameProvider;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.metadata.ExecutableDescriptor;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.ConstraintViolationImpl;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.CrossParameterD;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.ParameterD;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.job.ConstraintValidatorContextImpl;
import org.apache.bval.jsr.job.ValidateExecutable;
import org.apache.bval.jsr.job.ValidationJob;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class ValidateParameters<E extends Executable, T>
extends ValidateExecutable<E, T> {
    private static final String PARAMETERS_DO_NOT_MATCH = "Parameters do not match";
    protected final T object;
    protected final Lazy<List<String>> parameterNames = new Lazy<List>(() -> this.getParameterNames(this.validatorContext.getParameterNameProvider()));
    private final Object[] parameterValues;

    ValidateParameters(ApacheFactoryContext validatorContext, T object, E executable, Object[] parameterValues, Class<?>[] groups, Meta<E> meta) {
        super(validatorContext, groups, meta);
        this.object = object;
        this.parameterValues = (Object[])Validate.notNull(parameterValues, IllegalArgumentException::new, "null parameter values", new Object[0]).clone();
        Type[] genericParameterTypes = ((Executable)executable).getGenericParameterTypes();
        Exceptions.raiseUnless(parameterValues.length == genericParameterTypes.length, IllegalArgumentException::new, PARAMETERS_DO_NOT_MATCH, new Object[0]);
        IntStream.range(0, genericParameterTypes.length).forEach(n -> Exceptions.raiseUnless(TypeUtils.isInstance(parameterValues[n], genericParameterTypes[n]), IllegalArgumentException::new, PARAMETERS_DO_NOT_MATCH, new Object[0]));
    }

    @Override
    protected ValidationJob.Frame<?> computeBaseFrame() {
        return new ParametersFrame(this.describe(), new GraphContext(this.validatorContext, this.createBasePath().addNode(new NodeImpl.CrossParameterNodeImpl()), this.parameterValues));
    }

    @Override
    protected boolean hasWork() {
        return this.describe() != null;
    }

    protected abstract ExecutableDescriptor describe();

    protected abstract List<String> getParameterNames(ParameterNameProvider var1);

    protected abstract T getRootBean();

    @Override
    ConstraintViolationImpl<T> createViolation(String messageTemplate, String message, ConstraintValidatorContextImpl<T> context, PathImpl propertyPath) {
        return new ConstraintViolationImpl<T>(messageTemplate, message, this.getRootBean(), context.getFrame().getBean(), propertyPath, context.getFrame().context.getValue(), context.getConstraintDescriptor(), this.getRootBeanClass(), ((ConstraintD)context.getConstraintDescriptor().unwrap(ConstraintD.class)).getDeclaredOn(), null, this.parameterValues);
    }

    private GraphContext parameter(int i) {
        PathImpl path = this.createBasePath();
        path.addNode(new NodeImpl.ParameterNodeImpl(this.parameterNames.get().get(i), i));
        return new GraphContext(this.validatorContext, path, this.parameterValues[i]);
    }

    class ParametersFrame
    extends ValidationJob.Frame<CrossParameterD<?, ?>> {
        private final ExecutableDescriptor executableDescriptor;

        protected ParametersFrame(ExecutableDescriptor executableDescriptor, GraphContext context) {
            super((ValidationJob)ValidateParameters.this, null, (ElementD)((CrossParameterD)Validate.notNull(executableDescriptor, "executableDescriptor", new Object[0]).getCrossParameterDescriptor()), context);
            this.executableDescriptor = executableDescriptor;
        }

        @Override
        protected ValidationTarget getValidationTarget() {
            return ValidationTarget.PARAMETERS;
        }

        @Override
        void process(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            Validate.notNull(sink, "sink", new Object[0]);
            Lazy<Set> parameterFrames = new Lazy<Set>(this::parameterFrames);
            GroupStrategy.redefining(groups, Collections.singletonMap(Group.DEFAULT, ((CrossParameterD)this.descriptor).getGroupStrategy())).applyTo(ValidateParameters.this.noViolations(gs -> {
                this.validateDescriptorConstraints((GroupStrategy)gs, sink);
                ((Set)parameterFrames.get()).forEach(p -> p.validateDescriptorConstraints((GroupStrategy)gs, sink));
            }));
            parameterFrames.get().forEach(p -> p.recurse(groups, sink));
        }

        @Override
        Object getBean() {
            return ValidateParameters.this.object;
        }

        private Set<ValidationJob.Frame<?>> parameterFrames() {
            return this.executableDescriptor.getParameterDescriptors().stream().map(pd -> new ValidationJob.SproutFrame((ValidationJob)ValidateParameters.this, (ValidationJob.Frame)this, (ElementD)((ParameterD)pd), ValidateParameters.this.parameter(pd.getIndex()))).collect(Collectors.toSet());
        }
    }

    public static class ForConstructor<T>
    extends ValidateParameters<Constructor<? extends T>, T> {
        ForConstructor(ApacheFactoryContext validatorContext, Constructor<? extends T> executable, Object[] parameterValues, Class<?>[] groups) {
            super(validatorContext, null, (Executable)Validate.notNull(executable, IllegalArgumentException::new, "null ctor", new Object[0]), parameterValues, groups, new Meta.ForConstructor<T>(executable));
        }

        @Override
        protected ExecutableDescriptor describe() {
            return this.validatorContext.getDescriptorManager().getBeanDescriptor(((Constructor)this.executable).getDeclaringClass()).getConstraintsForConstructor((Class[])((Constructor)this.executable).getParameterTypes());
        }

        @Override
        protected Class<T> getRootBeanClass() {
            return ((Constructor)this.executable).getDeclaringClass();
        }

        @Override
        protected List<String> getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames((Constructor)this.executable);
        }

        @Override
        protected T getRootBean() {
            return null;
        }
    }

    public static class ForMethod<T>
    extends ValidateParameters<Method, T> {
        ForMethod(ApacheFactoryContext validatorContext, T object, Method executable, Object[] parameterValues, Class<?>[] groups) {
            super(validatorContext, object, (Executable)Validate.notNull(executable, IllegalArgumentException::new, "null method", new Object[0]), parameterValues, groups, new Meta.ForMethod(executable));
            Validate.notNull(object, IllegalArgumentException::new, "object", new Object[0]);
        }

        @Override
        protected ExecutableDescriptor describe() {
            return this.validatorContext.getDescriptorManager().getBeanDescriptor(this.object.getClass()).getConstraintsForMethod(((Method)this.executable).getName(), (Class[])((Method)this.executable).getParameterTypes());
        }

        @Override
        protected Class<T> getRootBeanClass() {
            return this.object.getClass();
        }

        @Override
        protected List<String> getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames((Method)this.executable);
        }

        @Override
        protected T getRootBean() {
            return (T)this.object;
        }
    }
}

