/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.FilterRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class DeprecationRestHandler
extends FilterRestHandler
implements RestHandler {
    public static final String DEPRECATED_ROUTE_KEY = "deprecated_route";
    private final String deprecationMessage;
    private final DeprecationLogger deprecationLogger;
    private final String deprecationKey;
    @Nullable
    private final Level deprecationLevel;

    public DeprecationRestHandler(RestHandler handler, RestRequest.Method method, String path, @Nullable Level deprecationLevel, String deprecationMessage, DeprecationLogger deprecationLogger) {
        super(handler);
        this.deprecationMessage = DeprecationRestHandler.requireValidHeader(deprecationMessage);
        this.deprecationLogger = Objects.requireNonNull(deprecationLogger);
        this.deprecationKey = "deprecated_route_" + (Object)((Object)method) + "_" + path;
        if (deprecationLevel != null && deprecationLevel != Level.WARN && deprecationLevel != DeprecationLogger.CRITICAL) {
            throw new IllegalArgumentException("unexpected deprecation logger level: " + deprecationLevel + ", expected either 'CRITICAL' or 'WARN'");
        }
        this.deprecationLevel = deprecationLevel;
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (this.deprecationLevel == null || this.deprecationLevel == DeprecationLogger.CRITICAL) {
            this.deprecationLogger.critical(DeprecationCategory.API, this.deprecationKey, this.deprecationMessage, new Object[0]);
        } else {
            this.deprecationLogger.warn(DeprecationCategory.API, this.deprecationKey, this.deprecationMessage, new Object[0]);
        }
        this.getDelegate().handleRequest(request, channel, client);
    }

    public static boolean validHeaderValue(String value) {
        if (!Strings.hasText(value)) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String requireValidHeader(String value) {
        if (!DeprecationRestHandler.validHeaderValue(value)) {
            throw new IllegalArgumentException("header value must contain only US ASCII text");
        }
        return value;
    }
}

