/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Objects;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContentObject;

public abstract class ShardOperationFailedException
extends Exception
implements Writeable,
ToXContentObject {
    protected String index;
    protected int shardId = -1;
    protected String reason;
    protected RestStatus status;
    protected Throwable cause;

    protected ShardOperationFailedException() {
    }

    protected ShardOperationFailedException(@Nullable String index, int shardId, String reason, RestStatus status, Throwable cause) {
        this.index = index;
        this.shardId = shardId;
        this.reason = Objects.requireNonNull(reason, "reason cannot be null");
        this.status = Objects.requireNonNull(status, "status cannot be null");
        this.cause = Objects.requireNonNull(cause, "cause cannot be null");
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    public final int shardId() {
        return this.shardId;
    }

    public final String reason() {
        return this.reason;
    }

    public final RestStatus status() {
        return this.status;
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }
}

