/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.BytesReferenceStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ReleasableBytesReference
implements RefCounted,
Releasable,
BytesReference {
    public static final Releasable NO_OP = () -> {};
    private static final ReleasableBytesReference EMPTY = new ReleasableBytesReference((BytesReference)BytesArray.EMPTY, NO_OP);
    private final BytesReference delegate;
    private final AbstractRefCounted refCounted;

    public static ReleasableBytesReference empty() {
        EMPTY.incRef();
        return EMPTY;
    }

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        this(delegate, new RefCountedReleasable(releasable));
    }

    public ReleasableBytesReference(BytesReference delegate, AbstractRefCounted refCounted) {
        this.delegate = delegate;
        this.refCounted = refCounted;
        assert (refCounted.refCount() > 0);
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        assert (!(reference instanceof ReleasableBytesReference)) : "use #retain() instead of #wrap() on a " + reference.getClass();
        return reference.length() == 0 ? ReleasableBytesReference.empty() : new ReleasableBytesReference(reference, NO_OP);
    }

    public int refCount() {
        return this.refCounted.refCount();
    }

    public void incRef() {
        this.refCounted.incRef();
    }

    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    public boolean decRef() {
        return this.refCounted.decRef();
    }

    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    public ReleasableBytesReference retain() {
        this.refCounted.incRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        if (from == 0 && this.length() == length) {
            return this.retain();
        }
        BytesReference slice = this.delegate.slice(from, length);
        this.refCounted.incRef();
        return new ReleasableBytesReference(slice, this.refCounted);
    }

    public void close() {
        this.refCounted.decRef();
    }

    @Override
    public byte get(int index) {
        assert (this.refCount() > 0);
        return this.delegate.get(index);
    }

    @Override
    public int getInt(int index) {
        assert (this.refCount() > 0);
        return this.delegate.getInt(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        assert (this.refCount() > 0);
        return this.delegate.indexOf(marker, from);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public BytesReference slice(int from, int length) {
        assert (this.refCount() > 0);
        return this.delegate.slice(from, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Override
    public StreamInput streamInput() throws IOException {
        assert (this.refCount() > 0);
        return new BytesReferenceStreamInput(this){

            @Override
            public ReleasableBytesReference readReleasableBytesReference() throws IOException {
                int len = this.readArraySize();
                ReleasableBytesReference result = ReleasableBytesReference.this.retainedSlice(this.offset(), len);
                this.skip(len);
                return result;
            }
        };
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        assert (this.refCount() > 0);
        this.delegate.writeTo(os);
    }

    @Override
    public String utf8ToString() {
        assert (this.refCount() > 0);
        return this.delegate.utf8ToString();
    }

    @Override
    public BytesRef toBytesRef() {
        assert (this.refCount() > 0);
        return this.delegate.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        assert (this.refCount() > 0);
        return this.delegate.iterator();
    }

    @Override
    public int compareTo(BytesReference o) {
        assert (this.refCount() > 0);
        return this.delegate.compareTo(o);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.refCount() > 0);
        return this.delegate.toXContent(builder, params);
    }

    public boolean isFragment() {
        return this.delegate.isFragment();
    }

    public boolean equals(Object obj) {
        assert (this.refCount() > 0);
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        assert (this.refCount() > 0);
        return this.delegate.hashCode();
    }

    @Override
    public boolean hasArray() {
        assert (this.refCount() > 0);
        return this.delegate.hasArray();
    }

    @Override
    public byte[] array() {
        assert (this.refCount() > 0);
        return this.delegate.array();
    }

    @Override
    public int arrayOffset() {
        assert (this.refCount() > 0);
        return this.delegate.arrayOffset();
    }

    private static final class RefCountedReleasable
    extends AbstractRefCounted {
        private final Releasable releasable;

        RefCountedReleasable(Releasable releasable) {
            this.releasable = releasable;
        }

        protected void closeInternal() {
            Releasables.closeExpectNoException((Releasable)this.releasable);
        }
    }
}

