/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField FAILED_INDICES_FIELD = new ParseField("failed_indices", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private final String[] indices;
    private final Map<String, Map<String, FieldCapabilities>> responseMap;
    private final List<FieldCapabilitiesFailure> failures;
    private final List<FieldCapabilitiesIndexResponse> indexResponses;
    private static final ConstructingObjectParser<FieldCapabilitiesResponse, Void> PARSER = new ConstructingObjectParser("field_capabilities_response", true, a -> {
        Map<String, Map<String, FieldCapabilities>> responseMap = ((List)a[0]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        List indices = a[1] == null ? Collections.emptyList() : (List)a[1];
        List failures = a[2] == null ? Collections.emptyList() : (List)a[2];
        return new FieldCapabilitiesResponse((String[])indices.stream().toArray(String[]::new), responseMap, failures);
    });

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> responseMap, List<FieldCapabilitiesFailure> failures) {
        this(indices, responseMap, Collections.emptyList(), failures);
    }

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> responseMap) {
        this(indices, responseMap, Collections.emptyList(), Collections.emptyList());
    }

    FieldCapabilitiesResponse(List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures) {
        this(Strings.EMPTY_ARRAY, Collections.emptyMap(), indexResponses, failures);
    }

    private FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> responseMap, List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures) {
        this.responseMap = Objects.requireNonNull(responseMap);
        this.indexResponses = Objects.requireNonNull(indexResponses);
        this.indices = indices;
        this.failures = failures;
    }

    public FieldCapabilitiesResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readStringArray() : Strings.EMPTY_ARRAY;
        this.responseMap = in.readMap(StreamInput::readString, FieldCapabilitiesResponse::readField);
        IndexFieldCapabilities.Deduplicator fieldDeduplicator = new IndexFieldCapabilities.Deduplicator();
        this.indexResponses = in.readList(is -> new FieldCapabilitiesIndexResponse(is, fieldDeduplicator));
        this.failures = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readList(FieldCapabilitiesFailure::new) : Collections.emptyList();
    }

    public String[] getIndices() {
        return this.indices;
    }

    public String[] getFailedIndices() {
        return (String[])this.failures.stream().map(FieldCapabilitiesFailure::getIndices).flatMap(s -> Arrays.stream(s)).toArray(String[]::new);
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.responseMap;
    }

    public List<FieldCapabilitiesFailure> getFailures() {
        return this.failures;
    }

    List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.responseMap.get(field);
    }

    public boolean isMetadataField(String field) {
        Map<String, FieldCapabilities> caps = this.getField(field);
        if (caps == null) {
            return false;
        }
        return caps.values().stream().anyMatch(FieldCapabilities::isMetadataField);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(StreamInput::readString, FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeStringArray(this.indices);
        }
        out.writeMap(this.responseMap, StreamOutput::writeString, FieldCapabilitiesResponse::writeField);
        out.writeList(this.indexResponses);
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeList(this.failures);
        }
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.indexResponses.size() > 0) {
            throw new IllegalStateException("cannot serialize non-merged response");
        }
        builder.startObject();
        builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(FIELDS_FIELD.getPreferredName(), this.responseMap);
        if (this.failures.size() > 0) {
            builder.field(FAILED_INDICES_FIELD.getPreferredName(), this.getFailedIndices().length);
            builder.xContentList(FAILURES_FIELD.getPreferredName(), this.failures);
        }
        builder.endObject();
        return builder;
    }

    public static FieldCapabilitiesResponse fromXContent(XContentParser parser) throws IOException {
        return (FieldCapabilitiesResponse)PARSER.parse(parser, null);
    }

    private static Map<String, FieldCapabilities> parseTypeToCapabilities(XContentParser parser, String name) throws IOException {
        XContentParser.Token token;
        HashMap<String, FieldCapabilities> typeToCapabilities = new HashMap<String, FieldCapabilities>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String type = parser.currentName();
            FieldCapabilities capabilities = FieldCapabilities.fromXContent(name, parser);
            typeToCapabilities.put(type, capabilities);
        }
        return typeToCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.responseMap, that.responseMap) && Objects.equals(this.indexResponses, that.indexResponses) && Objects.equals(this.failures, that.failures);
    }

    public int hashCode() {
        int result = Objects.hash(this.responseMap, this.indexResponses, this.failures);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            Map<String, FieldCapabilities> typeToCapabilities = FieldCapabilitiesResponse.parseTypeToCapabilities(p, n);
            return new Tuple((Object)n, typeToCapabilities);
        }, FIELDS_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FieldCapabilitiesFailure.fromXContent(p), FAILURES_FIELD);
    }
}

