/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.tasks.TaskId;
import org.elasticsearch.core.TimeValue;

public class CancelTasksRequest
implements Validatable {
    private final List<String> nodes = new ArrayList<String>();
    private final List<String> actions = new ArrayList<String>();
    private Optional<TimeValue> timeout = Optional.empty();
    private Optional<TaskId> parentTaskId = Optional.empty();
    private Optional<TaskId> taskId = Optional.empty();
    private Boolean waitForCompletion;

    CancelTasksRequest() {
    }

    void setNodes(List<String> nodes) {
        this.nodes.addAll(nodes);
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    void setTimeout(TimeValue timeout) {
        this.timeout = Optional.of(timeout);
    }

    public Optional<TimeValue> getTimeout() {
        return this.timeout;
    }

    void setActions(List<String> actions) {
        this.actions.addAll(actions);
    }

    public List<String> getActions() {
        return this.actions;
    }

    void setParentTaskId(TaskId parentTaskId) {
        this.parentTaskId = Optional.of(parentTaskId);
    }

    public Optional<TaskId> getParentTaskId() {
        return this.parentTaskId;
    }

    void setTaskId(TaskId taskId) {
        this.taskId = Optional.of(taskId);
    }

    public Optional<TaskId> getTaskId() {
        return this.taskId;
    }

    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelTasksRequest)) {
            return false;
        }
        CancelTasksRequest that = (CancelTasksRequest)o;
        return Objects.equals(this.getNodes(), that.getNodes()) && Objects.equals(this.getActions(), that.getActions()) && Objects.equals(this.getTimeout(), that.getTimeout()) && Objects.equals(this.getParentTaskId(), that.getParentTaskId()) && Objects.equals(this.getTaskId(), that.getTaskId()) && Objects.equals(this.waitForCompletion, that.waitForCompletion);
    }

    public int hashCode() {
        return Objects.hash(this.getNodes(), this.getActions(), this.getTimeout(), this.getParentTaskId(), this.getTaskId(), this.waitForCompletion);
    }

    public String toString() {
        return "CancelTasksRequest{nodes=" + this.nodes + ", actions=" + this.actions + ", timeout=" + this.timeout + ", parentTaskId=" + this.parentTaskId + ", taskId=" + this.taskId + ", waitForCompletion=" + this.waitForCompletion + '}';
    }

    public static class Builder {
        private Optional<TimeValue> timeout = Optional.empty();
        private Optional<TaskId> taskId = Optional.empty();
        private Optional<TaskId> parentTaskId = Optional.empty();
        private List<String> actionsFilter = new ArrayList<String>();
        private List<String> nodesFilter = new ArrayList<String>();
        private Boolean waitForCompletion;

        public Builder withTimeout(TimeValue timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder withTaskId(TaskId taskId) {
            this.taskId = Optional.of(taskId);
            return this;
        }

        public Builder withParentTaskId(TaskId taskId) {
            this.parentTaskId = Optional.of(taskId);
            return this;
        }

        public Builder withActionsFiltered(List<String> actions) {
            this.actionsFilter.clear();
            this.actionsFilter.addAll(actions);
            return this;
        }

        public Builder withNodesFiltered(List<String> nodes) {
            this.nodesFilter.clear();
            this.nodesFilter.addAll(nodes);
            return this;
        }

        public Builder withWaitForCompletion(boolean waitForCompletion) {
            this.waitForCompletion = waitForCompletion;
            return this;
        }

        public CancelTasksRequest build() {
            CancelTasksRequest request = new CancelTasksRequest();
            this.timeout.ifPresent(request::setTimeout);
            this.taskId.ifPresent(request::setTaskId);
            this.parentTaskId.ifPresent(request::setParentTaskId);
            request.setNodes(this.nodesFilter);
            request.setActions(this.actionsFilter);
            if (this.waitForCompletion != null) {
                request.setWaitForCompletion(this.waitForCompletion);
            }
            return request;
        }
    }
}

