/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerResourceEvaluatorsRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerResourceEvaluatorsRetriever.class);

    public static <T extends RangerResourceEvaluator> Collection<T> getEvaluators(Map<String, RangerResourceTrie<T>> resourceTrie, Map<String, ?> resource) {
        return RangerResourceEvaluatorsRetriever.getEvaluators(resourceTrie, resource, RangerAccessRequest.ResourceMatchingScope.SELF);
    }

    public static <T extends RangerResourceEvaluator> Collection<T> getEvaluators(Map<String, RangerResourceTrie<T>> resourceTrie, Map<String, ?> resource, RangerAccessRequest.ResourceMatchingScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyResourceEvaluatorsRetriever.getEvaluators(" + resource + ")");
        }
        Set ret = null;
        if (MapUtils.isNotEmpty(resourceTrie) && MapUtils.isNotEmpty(resource)) {
            Set<String> resourceKeys = resource.keySet();
            ArrayList<Evaluators<T>> sortedEvaluators = new ArrayList<Evaluators<T>>(resourceKeys.size());
            for (String string : resourceKeys) {
                RangerResourceTrie<T> trie = resourceTrie.get(string);
                if (trie == null) continue;
                Object resourceValues = resource.get(string);
                Set<T> inheritedMatchers = trie.getInheritedEvaluators();
                Set<T> matchersForResource = trie.getEvaluatorsForResource(resourceValues, scope);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ResourceDefName:[" + string + "], values:[" + resourceValues + "], resource-matchers:[" + matchersForResource + "], inherited-matchers:[" + inheritedMatchers + "]");
                }
                if (CollectionUtils.isEmpty(inheritedMatchers) && CollectionUtils.isEmpty(matchersForResource)) {
                    sortedEvaluators.clear();
                    break;
                }
                sortedEvaluators.add(new Evaluators<T>(inheritedMatchers, matchersForResource));
            }
            if (CollectionUtils.isNotEmpty(sortedEvaluators)) {
                Collections.sort(sortedEvaluators);
                ret = ((Evaluators)sortedEvaluators.remove(0)).getMatchers();
                for (Evaluators evaluators : sortedEvaluators) {
                    if (CollectionUtils.isEmpty((Collection)evaluators.inheritedMatchers)) {
                        ret.retainAll(evaluators.resourceMatchers);
                    } else if (CollectionUtils.isEmpty((Collection)evaluators.resourceMatchers)) {
                        ret.retainAll(evaluators.inheritedMatchers);
                    } else {
                        Set smaller = evaluators.getSmaller();
                        Set bigger = evaluators.getBigger();
                        HashSet tmp = new HashSet(ret.size());
                        if (ret.size() < smaller.size()) {
                            ret.stream().filter(smaller::contains).forEach(tmp::add);
                            ret.stream().filter(bigger::contains).forEach(tmp::add);
                        } else {
                            smaller.stream().filter(ret::contains).forEach(tmp::add);
                            if (ret.size() < bigger.size()) {
                                ret.stream().filter(bigger::contains).forEach(tmp::add);
                            } else {
                                bigger.stream().filter(ret::contains).forEach(tmp::add);
                            }
                        }
                        ret = tmp;
                    }
                    if (!ret.isEmpty()) continue;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceEvaluatorsRetriever.getEvaluators(" + resource + ") : evaluator:[" + ret + "]");
        }
        return ret;
    }

    static class Evaluators<T>
    implements Comparable<Evaluators<T>> {
        private final Set<T> inheritedMatchers;
        private final Set<T> resourceMatchers;
        private final Set<T> smaller;
        private final Set<T> bigger;
        private final int size;

        Evaluators(Set<T> inherited, Set<T> matched) {
            this.inheritedMatchers = inherited == null ? Collections.emptySet() : inherited;
            this.resourceMatchers = matched == null ? Collections.emptySet() : matched;
            this.size = this.inheritedMatchers.size() + this.resourceMatchers.size();
            this.smaller = this.inheritedMatchers.size() < this.resourceMatchers.size() ? this.inheritedMatchers : this.resourceMatchers;
            this.bigger = this.smaller == this.inheritedMatchers ? this.resourceMatchers : this.inheritedMatchers;
        }

        Set<T> getMatchers() {
            HashSet<T> ret = new HashSet<T>(this.size);
            ret.addAll(this.inheritedMatchers);
            ret.addAll(this.resourceMatchers);
            return ret;
        }

        Set<T> getSmaller() {
            return this.smaller;
        }

        Set<T> getBigger() {
            return this.bigger;
        }

        @Override
        public int compareTo(Evaluators<T> other) {
            return Integer.compare(this.size, other.size);
        }
    }
}

