/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerConfiguration.class);

    protected RangerConfiguration() {
        super(false);
    }

    public boolean addResourceIfReadable(String aResourceName) {
        URL fUrl;
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addResourceIfReadable(" + aResourceName + ")");
        }
        if ((fUrl = this.getFileLocation(aResourceName)) != null) {
            LOG.info("addResourceIfReadable(" + aResourceName + "): resource file is " + fUrl);
            try {
                this.addResource(fUrl);
                ret = true;
            }
            catch (Exception e) {
                LOG.error("Unable to load the resource name [" + aResourceName + "]. Ignoring the resource:" + fUrl);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resource loading failed for " + fUrl, (Throwable)e);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("addResourceIfReadable(" + aResourceName + "): couldn't find resource file location, the values is null. Ignoring it.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addResourceIfReadable(" + aResourceName + "), result=" + ret);
        }
        return ret;
    }

    public Properties getProperties() {
        return this.getProps();
    }

    private URL getFileLocation(String fileName) {
        URL lurl = null;
        if (!StringUtils.isEmpty((String)fileName)) {
            lurl = RangerConfiguration.class.getClassLoader().getResource(fileName);
            if (lurl == null) {
                lurl = RangerConfiguration.class.getClassLoader().getResource("/" + fileName);
            }
            if (lurl == null) {
                File f = new File(fileName);
                if (f.exists()) {
                    try {
                        lurl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Unable to load the resource name [" + fileName + "]. Ignoring the resource:" + f.getPath());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Conf file path " + fileName + " does not exists");
                }
            }
        }
        return lurl;
    }
}

