/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import javax.management.JMException;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.admin.AdminServer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class QuorumPeerMain {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerMain.class);
    private static final String USAGE = "Usage: QuorumPeerMain configfile";
    protected QuorumPeer quorumPeer;

    public static void main(String[] args) {
        QuorumPeerMain main = new QuorumPeerMain();
        try {
            main.initializeAndRun(args);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
            LOG.info(USAGE);
            System.err.println(USAGE);
            System.exit(2);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            LOG.error("Invalid config, exiting abnormally", (Throwable)e);
            System.err.println("Invalid config, exiting abnormally");
            System.exit(2);
        }
        catch (FileTxnSnapLog.DatadirException e) {
            LOG.error("Unable to access datadir, exiting abnormally", (Throwable)e);
            System.err.println("Unable to access datadir, exiting abnormally");
            System.exit(3);
        }
        catch (AdminServer.AdminServerException e) {
            LOG.error("Unable to start AdminServer, exiting abnormally", (Throwable)e);
            System.err.println("Unable to start AdminServer, exiting abnormally");
            System.exit(4);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Exiting normally");
        System.exit(0);
    }

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        if (args.length == 1) {
            config.parse(args[0]);
        }
        DatadirCleanupManager purgeMgr = new DatadirCleanupManager(config.getDataDir(), config.getDataLogDir(), config.getSnapRetainCount(), config.getPurgeInterval());
        purgeMgr.start();
        if (args.length == 1 && config.isDistributed()) {
            this.runFromConfig(config);
        } else {
            LOG.warn("Either no config or no quorum defined in config, running  in standalone mode");
            ZooKeeperServerMain.main(args);
        }
    }

    public void runFromConfig(QuorumPeerConfig config) throws IOException, AdminServer.AdminServerException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException e) {
            LOG.warn("Unable to register log4j JMX control", (Throwable)e);
        }
        LOG.info("Starting quorum peer");
        try {
            ServerCnxnFactory cnxnFactory = null;
            ServerCnxnFactory secureCnxnFactory = null;
            if (config.getClientPortAddress() != null) {
                cnxnFactory = ServerCnxnFactory.createFactory();
                cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns(), false);
            }
            if (config.getSecureClientPortAddress() != null) {
                secureCnxnFactory = ServerCnxnFactory.createFactory();
                secureCnxnFactory.configure(config.getSecureClientPortAddress(), config.getMaxClientCnxns(), true);
            }
            this.quorumPeer = this.getQuorumPeer();
            this.quorumPeer.setTxnFactory(new FileTxnSnapLog(config.getDataLogDir(), config.getDataDir()));
            this.quorumPeer.enableLocalSessions(config.areLocalSessionsEnabled());
            this.quorumPeer.enableLocalSessionsUpgrading(config.isLocalSessionsUpgradingEnabled());
            this.quorumPeer.setElectionType(config.getElectionAlg());
            this.quorumPeer.setMyid(config.getServerId());
            this.quorumPeer.setTickTime(config.getTickTime());
            this.quorumPeer.setMinSessionTimeout(config.getMinSessionTimeout());
            this.quorumPeer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            this.quorumPeer.setInitLimit(config.getInitLimit());
            this.quorumPeer.setSyncLimit(config.getSyncLimit());
            this.quorumPeer.setConfigFileName(config.getConfigFilename());
            this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
            this.quorumPeer.setQuorumVerifier(config.getQuorumVerifier(), false);
            if (config.getLastSeenQuorumVerifier() != null) {
                this.quorumPeer.setLastSeenQuorumVerifier(config.getLastSeenQuorumVerifier(), false);
            }
            this.quorumPeer.initConfigInZKDatabase();
            this.quorumPeer.setCnxnFactory(cnxnFactory);
            this.quorumPeer.setSecureCnxnFactory(secureCnxnFactory);
            this.quorumPeer.setSslQuorum(config.isSslQuorum());
            this.quorumPeer.setUsePortUnification(config.shouldUsePortUnification());
            this.quorumPeer.setLearnerType(config.getPeerType());
            this.quorumPeer.setSyncEnabled(config.getSyncEnabled());
            this.quorumPeer.setQuorumListenOnAllIPs(config.getQuorumListenOnAllIPs());
            if (config.sslQuorumReloadCertFiles) {
                this.quorumPeer.getX509Util().enableCertFileReloading();
            }
            this.quorumPeer.setQuorumSaslEnabled(config.quorumEnableSasl);
            if (this.quorumPeer.isQuorumSaslAuthEnabled()) {
                this.quorumPeer.setQuorumServerSaslRequired(config.quorumServerRequireSasl);
                this.quorumPeer.setQuorumLearnerSaslRequired(config.quorumLearnerRequireSasl);
                this.quorumPeer.setQuorumServicePrincipal(config.quorumServicePrincipal);
                this.quorumPeer.setQuorumServerLoginContext(config.quorumServerLoginContext);
                this.quorumPeer.setQuorumLearnerLoginContext(config.quorumLearnerLoginContext);
            }
            this.quorumPeer.setQuorumCnxnThreadsSize(config.quorumCnxnThreadsSize);
            this.quorumPeer.initialize();
            this.quorumPeer.start();
            this.quorumPeer.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Quorum Peer interrupted", (Throwable)e);
        }
    }

    protected QuorumPeer getQuorumPeer() throws SaslException {
        return new QuorumPeer();
    }
}

