/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.indices.DataStream;
import org.elasticsearch.xcontent.XContentParser;

public class GetDataStreamResponse {
    private final List<DataStream> dataStreams;

    GetDataStreamResponse(List<DataStream> dataStreams) {
        this.dataStreams = dataStreams;
    }

    public List<DataStream> getDataStreams() {
        return this.dataStreams;
    }

    public static GetDataStreamResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<DataStream> templates = new ArrayList<DataStream>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_ARRAY) {
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    templates.add(DataStream.fromXContent(parser));
                }
            }
            token = parser.nextToken();
        }
        return new GetDataStreamResponse(templates);
    }

    public int hashCode() {
        return Objects.hash(new HashSet<DataStream>(this.dataStreams));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetDataStreamResponse other = (GetDataStreamResponse)obj;
        return Objects.equals(new HashSet<DataStream>(this.dataStreams), new HashSet<DataStream>(other.dataStreams));
    }

    public String toString() {
        ArrayList<DataStream> thisList = new ArrayList<DataStream>(this.dataStreams);
        thisList.sort(Comparator.comparing(DataStream::getName));
        return "GetDataStreamResponse [dataStreams=" + thisList + "]";
    }
}

