/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;

@ConfigGroup(prefix="ozone.om")
public class OzoneAclConfig {
    @Config(key="user.rights", defaultValue="ALL", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default user permissions set for an object in OzoneManager.")
    private String userDefaultRights;
    @Config(key="group.rights", defaultValue="ALL", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default group permissions set for an object in OzoneManager.")
    private String groupDefaultRights;

    public IAccessAuthorizer.ACLType getUserDefaultRights() {
        if (this.userDefaultRights == null) {
            return IAccessAuthorizer.ACLType.ALL;
        }
        return IAccessAuthorizer.ACLType.valueOf(this.userDefaultRights);
    }

    public IAccessAuthorizer.ACLType getGroupDefaultRights() {
        if (this.groupDefaultRights == null) {
            return IAccessAuthorizer.ACLType.ALL;
        }
        return IAccessAuthorizer.ACLType.valueOf(this.groupDefaultRights);
    }
}

