/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

class Timestamps {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    private static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final int PICOSECONDS_PER_MICROSECOND = 1000000;
    public static final int PICOSECONDS_PER_MILLISECOND = 1000000000;

    private Timestamps() {
    }

    public static long round(long value, int magnitude) {
        return Timestamps.roundDiv(value, POWERS_OF_TEN[magnitude]) * POWERS_OF_TEN[magnitude];
    }

    public static long roundDiv(long value, long factor) {
        if (value >= 0L) {
            return (value + factor / 2L) / factor;
        }
        return (value + 1L - factor / 2L) / factor;
    }

    public static String formatTimestamp(int precision, long epochMicros, int picosOfMicro, ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(Math.floorDiv(epochMicros, 1000000));
        long picoFraction = (long)Math.floorMod(epochMicros, 1000000) * 1000000L + (long)picosOfMicro;
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, zoneId);
        return Timestamps.formatTimestamp(precision, dateTime, picoFraction).toString();
    }

    public static String formatTimestampWithTimeZone(int precision, long epochMillis, int picosOfMilli, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(epochMillis);
        long picoFraction = (long)Math.floorMod(epochMillis, 1000) * 1000000000L + (long)picosOfMilli;
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, zoneId);
        return Timestamps.formatTimestamp(precision, dateTime, picoFraction).append(" ").append(zoneId.getId()).toString();
    }

    private static StringBuilder formatTimestamp(int precision, LocalDateTime dateTime, long picoFraction) {
        StringBuilder builder = new StringBuilder();
        builder.append(TIMESTAMP_FORMATTER.format(dateTime));
        if (precision > 0) {
            long scaledFraction = picoFraction / POWERS_OF_TEN[12 - precision];
            builder.append(".");
            builder.append(String.format("%0" + precision + "d", scaledFraction));
        }
        return builder;
    }
}

