/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Timestamps;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;

public final class SqlTimestampWithTimeZone {
    private static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    private static final int PICOSECONDS_PER_NANOSECOND = 1000;
    public static final String JSON_FORMAT = "uuuu-MM-dd HH:mm:ss[.SSS] VV";
    private final int precision;
    private final long epochMillis;
    private final int picosOfMilli;
    private final TimeZoneKey timeZoneKey;

    public static SqlTimestampWithTimeZone newInstance(int precision, Instant instant, ZoneId zoneId) {
        return SqlTimestampWithTimeZone.newInstanceWithRounding(precision, instant.toEpochMilli(), instant.getNano() % 1000000 * 1000, TimeZoneKey.getTimeZoneKey(zoneId.getId()));
    }

    public static SqlTimestampWithTimeZone newInstance(int precision, long epochMillis, int picosOfMilli, TimeZoneKey timeZoneKey) {
        return SqlTimestampWithTimeZone.newInstanceWithRounding(precision, epochMillis, picosOfMilli, timeZoneKey);
    }

    private static SqlTimestampWithTimeZone newInstanceWithRounding(int precision, long epochMillis, int picosOfMilli, TimeZoneKey sessionTimeZoneKey) {
        if (precision < 3) {
            epochMillis = Timestamps.round(epochMillis, 3 - precision);
            picosOfMilli = 0;
        } else if (precision == 3) {
            if (Timestamps.round(picosOfMilli, 12 - precision) == 1000000000L) {
                ++epochMillis;
            }
            picosOfMilli = 0;
        } else {
            picosOfMilli = (int)Timestamps.round(picosOfMilli, 12 - precision);
        }
        return new SqlTimestampWithTimeZone(precision, epochMillis, picosOfMilli, sessionTimeZoneKey);
    }

    private SqlTimestampWithTimeZone(int precision, long epochMillis, int picosOfMilli, TimeZoneKey timeZoneKey) {
        this.precision = precision;
        this.epochMillis = epochMillis;
        this.picosOfMilli = picosOfMilli;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getEpochMillis() {
        return this.epochMillis;
    }

    public int getPicosOfMilli() {
        return this.picosOfMilli;
    }

    public long getMillisUtc() {
        return this.epochMillis;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public SqlTimestampWithTimeZone roundTo(int precision) {
        return SqlTimestampWithTimeZone.newInstanceWithRounding(precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        return Timestamps.formatTimestampWithTimeZone(this.precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey.getZoneId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimestampWithTimeZone that = (SqlTimestampWithTimeZone)o;
        return this.precision == that.precision && this.epochMillis == that.epochMillis && this.picosOfMilli == that.picosOfMilli && this.timeZoneKey.equals(that.timeZoneKey);
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey);
    }
}

