/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.Int96ArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TimestampWithTimeZoneTypes;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;

class LongTimestampWithTimeZoneType
extends TimestampWithTimeZoneType {
    public LongTimestampWithTimeZoneType(int precision) {
        super(precision, LongTimestampWithTimeZone.class);
        if (precision < 4 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 4, 12));
        }
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int96ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int96ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.compareTo(leftBlock, leftPosition, rightBlock, rightPosition) == 0;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftPackedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(leftBlock, leftPosition);
        int leftFraction = LongTimestampWithTimeZoneType.getFraction(leftBlock, leftPosition);
        long rightPackedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(rightBlock, rightPosition);
        int rightFraction = LongTimestampWithTimeZoneType.getFraction(rightBlock, rightPosition);
        return UnscaledDecimal128Arithmetic.compare(leftFraction, leftPackedEpochMillis, rightFraction, rightPackedEpochMillis);
    }

    @Override
    public long hash(Block block, int position) {
        return TimestampWithTimeZoneTypes.hashLongTimestampWithTimeZone(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position), LongTimestampWithTimeZoneType.getFraction(block, position));
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
            blockBuilder.writeInt(LongTimestampWithTimeZoneType.getFraction(block, position));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int fraction = LongTimestampWithTimeZoneType.getFraction(block, position);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(DateTimeEncoding.unpackMillisUtc(packedEpochMillis), fraction, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)value;
        blockBuilder.writeLong(DateTimeEncoding.packDateTimeWithZone(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()));
        blockBuilder.writeInt(timestamp.getPicosOfMilli());
        blockBuilder.closeEntry();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int fraction = LongTimestampWithTimeZoneType.getFraction(block, position);
        return SqlTimestampWithTimeZone.newInstance(this.getPrecision(), DateTimeEncoding.unpackMillisUtc(packedEpochMillis), fraction, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    private static long getPackedEpochMillis(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static int getFraction(Block block, int position) {
        return block.getInt(position, 8);
    }
}

