/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class QueryId {
    private final String id;
    private static final Pattern ID_PATTERN = Pattern.compile("[_a-z0-9]+");

    @JsonCreator
    public static QueryId valueOf(String queryId) {
        List<String> ids = QueryId.parseDottedId(queryId, 1, "queryId");
        return new QueryId(ids.get(0));
    }

    public QueryId(String id) {
        this.id = QueryId.validateId(id);
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryId other = (QueryId)obj;
        return Objects.equals(this.id, other.id);
    }

    public static String validateId(String id) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(!id.isEmpty(), "id is empty", new Object[0]);
        QueryId.checkArgument(ID_PATTERN.matcher(id).matches(), "Invalid id %s", id);
        return id;
    }

    public static List<String> parseDottedId(String id, int expectedParts, String name) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(expectedParts > 0, "expectedParts must be at least 1", new Object[0]);
        Objects.requireNonNull(name, "name is null");
        List<String> ids = List.of(id.split("\\."));
        QueryId.checkArgument(ids.size() == expectedParts, "Invalid %s %s", name, id);
        for (String part : ids) {
            QueryId.checkArgument(!part.isEmpty(), "Invalid id %s", id);
            QueryId.checkArgument(ID_PATTERN.matcher(part).matches(), "Invalid id %s", id);
        }
        return ids;
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

