/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util.sql;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLPLRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;
    private static final String DELIMITER_LINE_REGEX = "(?i)delimiter.+";
    private static final String DELIMITER_LINE_SPLIT_REGEX = "(?i)delimiter";
    private boolean printDebug = false;

    public MySQLPLRunner(Connection connection, boolean autoCommit, boolean stopOnError, boolean printDebug) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
        this.printDebug = printDebug;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuilder command = null;
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                Matcher matcher;
                Pattern pattern;
                String trimmedLine;
                if (command == null) {
                    command = new StringBuilder();
                }
                if ((trimmedLine = line.trim()).length() < 1 || trimmedLine.startsWith("--") || trimmedLine.startsWith("//")) continue;
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                    matcher = pattern.matcher(trimmedLine);
                    if (matcher.matches()) {
                        this.setDelimiter(trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim(), this.fullLineDelimiter);
                        continue;
                    }
                    if (line != null && line.endsWith(this.getDelimiter()) && !DEFAULT_DELIMITER.equalsIgnoreCase(this.getDelimiter())) {
                        command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    } else {
                        command.append(line);
                    }
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    if (this.printDebug) {
                        this.println(command);
                    }
                    boolean hasResults = false;
                    if (this.stopOnError) {
                        hasResults = statement.execute(command.toString());
                    } else {
                        try {
                            statement.execute(command.toString());
                        }
                        catch (SQLException e) {
                            e.fillInStackTrace();
                            this.printlnError("Error executing: " + command);
                            this.printlnError(e);
                        }
                    }
                    if (this.autoCommit && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 1; i <= cols; ++i) {
                            String name = md.getColumnLabel(i);
                            this.print(name + "\t");
                        }
                        this.println("");
                        while (rs.next()) {
                            for (i = 1; i <= cols; ++i) {
                                String value = rs.getString(i);
                                this.print(value + "\t");
                            }
                            this.println("");
                        }
                    }
                    command = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Thread.yield();
                    continue;
                }
                pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                matcher = pattern.matcher(trimmedLine);
                if (matcher.matches()) {
                    this.setDelimiter(trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim(), this.fullLineDelimiter);
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        finally {
            conn.rollback();
            this.flush();
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            System.out.print(o);
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection con = null;
        String driverName = "com.mysql.jdbc.Driver";
        Properties props = null;
        try {
            Class.forName(driverName).newInstance();
            props = new Properties();
            props.put("user", "root");
            props.put("password", "root");
            String connectString = "jdbc:mysql://localhost:3306/ranger";
            con = DriverManager.getConnection(connectString, props);
            MySQLPLRunner scriptRunner = new MySQLPLRunner(con, false, true, true);
            String aSQLScriptFilePath = "/disk1/zero/jisql-2.0.11/xa_core_db.sql";
            FileReader reader = new FileReader(aSQLScriptFilePath);
            try {
                scriptRunner.runScript(reader);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Cannot find the driver class \"" + driverName + "\" in the current classpath.");
        }
        catch (InstantiationException ie) {
            System.err.println("Cannot instantiate the driver class \"" + driverName + "\"");
            ie.printStackTrace(System.err);
        }
        catch (IllegalAccessException iae) {
            System.err.println("Cannot instantiate the driver class \"" + driverName + "\" because of an IllegalAccessException");
            iae.printStackTrace(System.err);
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }
}

