/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.AbstractSingleMapBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleMapBlockWriter
extends AbstractSingleMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlockWriter.class).instanceSize();
    private final int offset;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private final Runnable setStrict;
    private final long initialBlockBuilderSize;
    private int positionsWritten;
    private boolean writeToValueNext;

    SingleMapBlockWriter(int start, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, Runnable setStrict) {
        this.offset = start;
        this.keyBlockBuilder = keyBlockBuilder;
        this.valueBlockBuilder = valueBlockBuilder;
        this.setStrict = setStrict;
        this.initialBlockBuilderSize = keyBlockBuilder.getSizeInBytes() + valueBlockBuilder.getSizeInBytes();
    }

    public SingleMapBlockWriter strict() {
        this.setStrict.run();
        return this;
    }

    @Override
    int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.keyBlockBuilder;
    }

    @Override
    Block getRawValueBlock() {
        return this.valueBlockBuilder;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeByte(value);
        } else {
            this.keyBlockBuilder.writeByte(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeShort(value);
        } else {
            this.keyBlockBuilder.writeShort(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeInt(value);
        } else {
            this.keyBlockBuilder.writeInt(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeLong(value);
        } else {
            this.keyBlockBuilder.writeLong(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeBytes(source, sourceIndex, length);
        } else {
            this.keyBlockBuilder.writeBytes(source, sourceIndex, length);
        }
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        BlockBuilder result = this.writeToValueNext ? this.valueBlockBuilder.beginBlockEntry() : this.keyBlockBuilder.beginBlockEntry();
        return result;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.appendNull();
        } else {
            this.keyBlockBuilder.appendNull();
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.closeEntry();
        } else {
            this.keyBlockBuilder.closeEntry();
        }
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        this.writeToValueNext = !this.writeToValueNext;
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("SingleMapBlockWriter{positionCount=%d}", this.getPositionCount());
    }
}

