/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class BasePartitionEvaluator {
    protected final GenericUDAFEvaluator wrappedEvaluator;
    protected final WindowFrameDef winFrame;
    protected final PTFPartition partition;
    protected final List<PTFExpressionDef> parameters;
    protected final ObjectInspector outputOI;

    public BasePartitionEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
        this.wrappedEvaluator = wrappedEvaluator;
        this.winFrame = winFrame;
        this.partition = partition;
        this.parameters = parameters;
        this.outputOI = outputOI;
    }

    public Object getPartitionAgg() throws HiveException {
        return this.calcFunctionValue(this.partition.iterator(), null);
    }

    public Object iterate(int currentRow, LeadLagInfo leadLagInfo) throws HiveException {
        Range range = BasePartitionEvaluator.getRange(this.winFrame, currentRow, this.partition);
        PTFPartition.PTFPartitionIterator<Object> pItr = range.iterator();
        return this.calcFunctionValue(pItr, leadLagInfo);
    }

    protected Object calcFunctionValue(PTFPartition.PTFPartitionIterator<Object> pItr, LeadLagInfo leadLagInfo) throws HiveException {
        PTFOperator.connectLeadLagFunctionsToPartition(leadLagInfo, pItr);
        GenericUDAFEvaluator.AggregationBuffer aggBuffer = this.wrappedEvaluator.getNewAggregationBuffer();
        Object[] argValues = new Object[this.parameters == null ? 0 : this.parameters.size()];
        while (pItr.hasNext()) {
            Object row = pItr.next();
            int i = 0;
            if (this.parameters != null) {
                for (PTFExpressionDef param : this.parameters) {
                    argValues[i++] = param.getExprEvaluator().evaluate(row);
                }
            }
            this.wrappedEvaluator.aggregate(aggBuffer, argValues);
        }
        return ObjectInspectorUtils.copyToStandardObject(this.wrappedEvaluator.evaluate(aggBuffer), this.outputOI);
    }

    protected static Range getRange(WindowFrameDef winFrame, int currRow, PTFPartition p) throws HiveException {
        int end;
        int start;
        BoundaryDef startB = winFrame.getStart();
        BoundaryDef endB = winFrame.getEnd();
        if (winFrame.getWindowType() == WindowingSpec.WindowType.ROWS) {
            start = BasePartitionEvaluator.getRowBoundaryStart(startB, currRow);
            end = BasePartitionEvaluator.getRowBoundaryEnd(endB, currRow, p);
        } else {
            ValueBoundaryScanner vbs = ValueBoundaryScanner.getScanner(winFrame);
            start = vbs.computeStart(currRow, p);
            end = vbs.computeEnd(currRow, p);
        }
        start = start < 0 ? 0 : start;
        end = end > p.size() ? p.size() : end;
        return new Range(start, end, p);
    }

    private static int getRowBoundaryStart(BoundaryDef b, int currRow) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == Integer.MAX_VALUE) {
                    return 0;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow;
            }
            case FOLLOWING: {
                return currRow + amt;
            }
        }
        throw new HiveException("Unknown Start Boundary Direction: " + d);
    }

    private static int getRowBoundaryEnd(BoundaryDef b, int currRow, PTFPartition p) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == 0) {
                    return currRow + 1;
                }
                return currRow - amt + 1;
            }
            case CURRENT: {
                return currRow + 1;
            }
            case FOLLOWING: {
                if (amt == Integer.MAX_VALUE) {
                    return p.size();
                }
                return currRow + amt + 1;
            }
        }
        throw new HiveException("Unknown End Boundary Direction: " + d);
    }

    public static class AvgPartitionHiveDecimalEvaluator
    extends AvgPartitionEvaluator<HiveDecimalWritable> {
        public AvgPartitionHiveDecimalEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector inputOI, ObjectInspector outputOI) throws HiveException {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
            this.typeOperation = new TypeOperationHiveDecimalWritable();
        }
    }

    public static class AvgPartitionDoubleEvaluator
    extends AvgPartitionEvaluator<DoubleWritable> {
        public AvgPartitionDoubleEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector inputOI, ObjectInspector outputOI) throws HiveException {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
            this.typeOperation = new TypeOperationDoubleWritable();
        }
    }

    public static abstract class AvgPartitionEvaluator<ResultType extends Writable>
    extends BasePartitionEvaluator {
        protected SumPartitionEvaluator<ResultType> sumEvaluator;
        protected TypeOperationBase<ResultType> typeOperation;
        WindowAvgAgg<ResultType> avgAgg = new WindowAvgAgg();

        public AvgPartitionEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
        }

        private Object[] calcPartialResult(PTFPartition.PTFPartitionIterator<Object> pItr, LeadLagInfo leadLagInfo) throws HiveException {
            PTFOperator.connectLeadLagFunctionsToPartition(leadLagInfo, pItr);
            GenericUDAFEvaluator.AggregationBuffer aggBuffer = this.wrappedEvaluator.getNewAggregationBuffer();
            Object[] argValues = new Object[this.parameters == null ? 0 : this.parameters.size()];
            while (pItr.hasNext()) {
                Object row = pItr.next();
                int i = 0;
                if (this.parameters != null) {
                    for (PTFExpressionDef param : this.parameters) {
                        argValues[i++] = param.getExprEvaluator().evaluate(row);
                    }
                }
                this.wrappedEvaluator.aggregate(aggBuffer, argValues);
            }
            Object[] partial = (Object[])this.wrappedEvaluator.terminatePartial(aggBuffer);
            return new Object[]{((LongWritable)partial[0]).get(), ObjectInspectorUtils.copyToStandardObject(partial[1], this.outputOI)};
        }

        @Override
        public Object iterate(int currentRow, LeadLagInfo leadLagInfo) throws HiveException {
            if (((GenericUDAFAverage.AbstractGenericUDAFAverageEvaluator)this.wrappedEvaluator).isWindowingDistinct()) {
                return super.iterate(currentRow, leadLagInfo);
            }
            Range currentRange = AvgPartitionEvaluator.getRange(this.winFrame, currentRow, this.partition);
            if (currentRow == 0 || this.avgAgg.prevRange == null || currentRange.getSize() <= currentRange.getDiff(this.avgAgg.prevRange)) {
                Object[] partial = this.calcPartialResult(currentRange.iterator(), leadLagInfo);
                this.avgAgg.prevRange = currentRange;
                this.avgAgg.empty = false;
                this.avgAgg.prevSum = (Writable)partial[1];
                this.avgAgg.prevCount = (Long)partial[0];
            } else {
                Range r1 = new Range(this.avgAgg.prevRange.start, currentRange.start, this.partition);
                Range r2 = new Range(this.avgAgg.prevRange.end, currentRange.end, this.partition);
                Object[] partial1 = this.calcPartialResult(r1.iterator(), leadLagInfo);
                Object[] partial2 = this.calcPartialResult(r2.iterator(), leadLagInfo);
                Writable sum = this.typeOperation.add(this.typeOperation.minus((Writable)this.avgAgg.prevSum, (Writable)partial1[1]), (Writable)partial2[1]);
                long count = this.avgAgg.prevCount - (Long)partial1[0] + (Long)partial2[0];
                this.avgAgg.prevRange = currentRange;
                this.avgAgg.prevSum = sum;
                this.avgAgg.prevCount = count;
            }
            return this.typeOperation.div((Writable)this.avgAgg.prevSum, this.avgAgg.prevCount);
        }

        static class WindowAvgAgg<ResultType>
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Range prevRange;
            ResultType prevSum;
            long prevCount;
            boolean empty;

            WindowAvgAgg() {
            }
        }
    }

    public static class SumPartitionHiveDecimalEvaluator
    extends SumPartitionEvaluator<HiveDecimalWritable> {
        public SumPartitionHiveDecimalEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
            this.typeOperation = new TypeOperationHiveDecimalWritable();
        }
    }

    public static class SumPartitionLongEvaluator
    extends SumPartitionEvaluator<LongWritable> {
        public SumPartitionLongEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
            this.typeOperation = new TypeOperationLongWritable();
        }
    }

    public static class SumPartitionDoubleEvaluator
    extends SumPartitionEvaluator<DoubleWritable> {
        public SumPartitionDoubleEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
            this.typeOperation = new TypeOperationDoubleWritable();
        }
    }

    public static abstract class SumPartitionEvaluator<ResultType extends Writable>
    extends BasePartitionEvaluator {
        protected final WindowSumAgg<ResultType> sumAgg = new WindowSumAgg();
        protected TypeOperationBase<ResultType> typeOperation;

        public SumPartitionEvaluator(GenericUDAFEvaluator wrappedEvaluator, WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI) {
            super(wrappedEvaluator, winFrame, partition, parameters, outputOI);
        }

        @Override
        public Object iterate(int currentRow, LeadLagInfo leadLagInfo) throws HiveException {
            Writable result;
            if (((GenericUDAFSum.GenericUDAFSumEvaluator)this.wrappedEvaluator).isWindowingDistinct()) {
                return super.iterate(currentRow, leadLagInfo);
            }
            Range currentRange = SumPartitionEvaluator.getRange(this.winFrame, currentRow, this.partition);
            if (currentRow == 0 || this.sumAgg.prevRange == null || currentRange.getSize() <= currentRange.getDiff(this.sumAgg.prevRange)) {
                result = (Writable)this.calcFunctionValue(currentRange.iterator(), leadLagInfo);
                this.sumAgg.prevRange = currentRange;
                this.sumAgg.empty = false;
                this.sumAgg.prevSum = result;
            } else {
                Range r1 = new Range(this.sumAgg.prevRange.start, currentRange.start, this.partition);
                Range r2 = new Range(this.sumAgg.prevRange.end, currentRange.end, this.partition);
                Writable sum1 = (Writable)this.calcFunctionValue(r1.iterator(), leadLagInfo);
                Writable sum2 = (Writable)this.calcFunctionValue(r2.iterator(), leadLagInfo);
                result = this.typeOperation.add(this.typeOperation.minus((Writable)this.sumAgg.prevSum, sum1), sum2);
                this.sumAgg.prevRange = currentRange;
                this.sumAgg.prevSum = result;
            }
            return result;
        }

        static class WindowSumAgg<ResultType>
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Range prevRange;
            ResultType prevSum;
            boolean empty;

            WindowSumAgg() {
            }
        }
    }

    private static class TypeOperationHiveDecimalWritable
    extends TypeOperationBase<HiveDecimalWritable> {
        private TypeOperationHiveDecimalWritable() {
        }

        @Override
        public HiveDecimalWritable div(HiveDecimalWritable sum, long numRows) {
            if (sum == null || numRows == 0L) {
                return null;
            }
            HiveDecimalWritable result = new HiveDecimalWritable(sum);
            result.mutateDivide(HiveDecimal.create(numRows));
            return result;
        }

        @Override
        public HiveDecimalWritable add(HiveDecimalWritable t1, HiveDecimalWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            if (t1 == null) {
                return new HiveDecimalWritable(t2);
            }
            HiveDecimalWritable result = new HiveDecimalWritable(t1);
            if (t2 != null) {
                result.mutateAdd(t2);
            }
            return result;
        }

        @Override
        public HiveDecimalWritable minus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            if (t2 == null) {
                return new HiveDecimalWritable(t1);
            }
            HiveDecimalWritable result = new HiveDecimalWritable(t2);
            result.mutateNegate();
            if (t1 != null) {
                result.mutateAdd(t1);
            }
            return result;
        }
    }

    private static class TypeOperationDoubleWritable
    extends TypeOperationBase<DoubleWritable> {
        private TypeOperationDoubleWritable() {
        }

        @Override
        public DoubleWritable add(DoubleWritable t1, DoubleWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            return new DoubleWritable((t1 == null ? 0.0 : t1.get()) + (t2 == null ? 0.0 : t2.get()));
        }

        @Override
        public DoubleWritable minus(DoubleWritable t1, DoubleWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            return new DoubleWritable((t1 == null ? 0.0 : t1.get()) - (t2 == null ? 0.0 : t2.get()));
        }

        @Override
        public DoubleWritable div(DoubleWritable sum, long numRows) {
            if (sum == null || numRows == 0L) {
                return null;
            }
            return new DoubleWritable(sum.get() / (double)numRows);
        }
    }

    private static class TypeOperationLongWritable
    extends TypeOperationBase<LongWritable> {
        private TypeOperationLongWritable() {
        }

        @Override
        public LongWritable add(LongWritable t1, LongWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            return new LongWritable((t1 == null ? 0L : t1.get()) + (t2 == null ? 0L : t2.get()));
        }

        @Override
        public LongWritable minus(LongWritable t1, LongWritable t2) {
            if (t1 == null && t2 == null) {
                return null;
            }
            return new LongWritable((t1 == null ? 0L : t1.get()) - (t2 == null ? 0L : t2.get()));
        }

        @Override
        public LongWritable div(LongWritable sum, long numRows) {
            return null;
        }
    }

    private static abstract class TypeOperationBase<ResultType> {
        private TypeOperationBase() {
        }

        public abstract ResultType add(ResultType var1, ResultType var2);

        public abstract ResultType minus(ResultType var1, ResultType var2);

        public abstract ResultType div(ResultType var1, long var2);
    }

    protected static class Range {
        int start;
        int end;
        PTFPartition p;

        public Range(int start, int end, PTFPartition p) {
            this.start = start;
            this.end = end;
            this.p = p;
        }

        public PTFPartition.PTFPartitionIterator<Object> iterator() {
            return this.p.range(this.start, this.end);
        }

        public int getDiff(Range prevRange) {
            return this.start - prevRange.start + this.end - prevRange.end;
        }

        public int getSize() {
            return this.end - this.start;
        }
    }
}

