/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.ext;

import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.ClientPrincipal;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.Server;
import org.apache.polaris.service.it.ext.PolarisServerManagerLoader;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.engine.UniqueId;

public class PolarisIntegrationTestExtension
implements ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PolarisIntegrationTestExtension.class});

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<Object> type = parameterContext.getParameter().getType();
        return type.isAssignableFrom(PolarisApiEndpoints.class) || type.isAssignableFrom(ClientPrincipal.class) || type.isAssignableFrom(ClientCredentials.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Env env = this.env(extensionContext);
        Class<Object> type = parameterContext.getParameter().getType();
        if (type.isAssignableFrom(PolarisApiEndpoints.class)) {
            return env.endpoints();
        }
        if (type.isAssignableFrom(ClientPrincipal.class)) {
            return env.server.adminCredentials();
        }
        if (type.isAssignableFrom(ClientCredentials.class)) {
            return env.server.adminCredentials().credentials();
        }
        throw new IllegalStateException("Unable to resolve parameter: " + String.valueOf(parameterContext));
    }

    private Env env(ExtensionContext context) {
        ExtensionContext classCtx = this.classContext(context);
        ExtensionContext.Store store = classCtx.getStore(NAMESPACE);
        return (Env)store.getOrComputeIfAbsent(Env.class, key -> new Env(PolarisServerManagerLoader.polarisServerManager().serverForContext(classCtx)), Env.class);
    }

    private ExtensionContext classContext(ExtensionContext context) {
        UniqueId id;
        while (context.getParent().isPresent() && !"class".equals((id = UniqueId.parse((String)context.getUniqueId())).getLastSegment().getType())) {
            context = (ExtensionContext)context.getParent().get();
        }
        return context;
    }

    private static class Env
    implements ExtensionContext.Store.CloseableResource {
        private final Server server;
        private final PolarisApiEndpoints endpoints;

        private Env(Server server) {
            this.server = server;
            this.endpoints = new PolarisApiEndpoints(server.baseUri(), server.realmId(), server.realmHeaderName());
        }

        PolarisApiEndpoints endpoints() {
            return this.endpoints;
        }

        public void close() throws Throwable {
            this.server.close();
        }
    }
}

