/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.persistence;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.LocalPolarisMetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.persistence.transactional.TreeMapMetaStore;
import org.apache.polaris.core.persistence.transactional.TreeMapTransactionalPersistenceImpl;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;

@ApplicationScoped
@Identifier(value="in-memory")
public class InMemoryPolarisMetaStoreManagerFactory
extends LocalPolarisMetaStoreManagerFactory<TreeMapMetaStore> {
    private final PolarisStorageIntegrationProvider storageIntegration;
    private final Set<String> bootstrappedRealms = new HashSet<String>();

    public InMemoryPolarisMetaStoreManagerFactory() {
        this(null, null, null);
    }

    @Inject
    public InMemoryPolarisMetaStoreManagerFactory(PolarisStorageIntegrationProvider storageIntegration, PolarisDiagnostics diagnostics, PolarisConfigurationStore configurationStore) {
        super(diagnostics, configurationStore);
        this.storageIntegration = storageIntegration;
    }

    protected TreeMapMetaStore createBackingStore(@Nonnull PolarisDiagnostics diagnostics) {
        return new TreeMapMetaStore(diagnostics);
    }

    protected TransactionalPersistence createMetaStoreSession(@Nonnull TreeMapMetaStore store, @Nonnull RealmContext realmContext, @Nullable RootCredentialsSet rootCredentialsSet, @Nonnull PolarisDiagnostics diagnostics) {
        return new TreeMapTransactionalPersistenceImpl(store, this.storageIntegration, this.secretsGenerator(realmContext, rootCredentialsSet));
    }

    public synchronized PolarisMetaStoreManager getOrCreateMetaStoreManager(RealmContext realmContext) {
        String realmId = realmContext.getRealmIdentifier();
        if (!this.bootstrappedRealms.contains(realmId)) {
            this.bootstrapRealmsFromEnvironment(List.of(realmId));
        }
        return super.getOrCreateMetaStoreManager(realmContext);
    }

    public synchronized Supplier<TransactionalPersistence> getOrCreateSessionSupplier(RealmContext realmContext) {
        String realmId = realmContext.getRealmIdentifier();
        if (!this.bootstrappedRealms.contains(realmId)) {
            this.bootstrapRealmsFromEnvironment(List.of(realmId));
        }
        return super.getOrCreateSessionSupplier(realmContext);
    }

    private void bootstrapRealmsFromEnvironment(List<String> realms) {
        RootCredentialsSet rootCredentialsSet = RootCredentialsSet.fromEnvironment();
        this.bootstrapRealms(realms, rootCredentialsSet);
    }

    public Map<String, PrincipalSecretsResult> bootstrapRealms(Iterable<String> realms, RootCredentialsSet rootCredentialsSet) {
        Map results = super.bootstrapRealms(realms, rootCredentialsSet);
        this.bootstrappedRealms.addAll(results.keySet());
        return results;
    }
}

