/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.exception;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.core.exceptions.AlreadyExistsException;
import org.apache.polaris.core.exceptions.PolarisException;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.policy.exceptions.PolicyAttachException;
import org.apache.polaris.core.policy.exceptions.PolicyInUseException;
import org.apache.polaris.core.policy.exceptions.PolicyVersionMismatchException;
import org.apache.polaris.core.policy.validator.InvalidPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Provider
public class PolarisExceptionMapper
implements ExceptionMapper<PolarisException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisExceptionMapper.class);

    private Response.Status getStatus(PolarisException exception) {
        if (exception instanceof AlreadyExistsException) {
            return Response.Status.CONFLICT;
        }
        if (exception instanceof InvalidPolicyException) {
            return Response.Status.BAD_REQUEST;
        }
        if (exception instanceof PolicyAttachException) {
            return Response.Status.BAD_REQUEST;
        }
        if (exception instanceof NoSuchPolicyException) {
            return Response.Status.NOT_FOUND;
        }
        if (exception instanceof PolicyVersionMismatchException) {
            return Response.Status.CONFLICT;
        }
        if (exception instanceof PolicyMappingAlreadyExistsException) {
            return Response.Status.CONFLICT;
        }
        if (exception instanceof PolicyInUseException) {
            return Response.Status.BAD_REQUEST;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    public Response toResponse(PolarisException exception) {
        Response.Status status = this.getStatus(exception);
        LOGGER.atLevel(status.getFamily() == Response.Status.Family.SERVER_ERROR ? Level.INFO : Level.DEBUG).log("Full PolarisException", (Object)exception);
        ErrorResponse errorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(status.getStatusCode())).withType(exception.getClass().getSimpleName()).withMessage(exception.getMessage()).build();
        return Response.status((Response.Status)status).entity((Object)errorResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

