/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

enum StorageTypeFileIO {
    S3("org.apache.iceberg.aws.s3.S3FileIO", true),
    GCS("org.apache.iceberg.gcp.gcs.GCSFileIO", true),
    AZURE("org.apache.iceberg.azure.adlsv2.ADLSFileIO", true),
    FILE("org.apache.iceberg.hadoop.HadoopFileIO", false),
    MFS("org.apache.iceberg.hadoop.HadoopFileIO", true),
    IN_MEMORY("org.apache.iceberg.inmemory.InMemoryFileIO", false, false);

    private final String fileIoImplementation;
    private final boolean safe;
    private final boolean validateAllowedStorageType;
    private static final Map<String, StorageTypeFileIO> FILE_TO_TO_STORAGE_TYPE;

    private StorageTypeFileIO(String fileIoImplementation, boolean safe) {
        this(fileIoImplementation, safe, true);
    }

    private StorageTypeFileIO(String fileIoImplementation, boolean safe, boolean validateAllowedStorageType) {
        this.fileIoImplementation = fileIoImplementation;
        this.safe = safe;
        this.validateAllowedStorageType = validateAllowedStorageType;
    }

    boolean safe() {
        return this.safe;
    }

    boolean validateAllowedStorageType() {
        return this.validateAllowedStorageType;
    }

    static StorageTypeFileIO fromFileIoImplementation(String fileIoImplementation) {
        StorageTypeFileIO type = FILE_TO_TO_STORAGE_TYPE.get(fileIoImplementation);
        if (type == null) {
            throw new IllegalArgumentException("Unknown FileIO implementation: " + fileIoImplementation);
        }
        return type;
    }

    static {
        HashMap<String, StorageTypeFileIO> map = new HashMap<String, StorageTypeFileIO>();
        for (PolarisStorageConfigurationInfo.StorageType storageType : PolarisStorageConfigurationInfo.StorageType.values()) {
            StorageTypeFileIO.valueOf(storageType.name());
        }
        for (StorageTypeFileIO storageTypeFileIO : StorageTypeFileIO.values()) {
            if (storageTypeFileIO.validateAllowedStorageType()) {
                PolarisStorageConfigurationInfo.StorageType.valueOf((String)storageTypeFileIO.name());
            }
            map.put(storageTypeFileIO.fileIoImplementation, storageTypeFileIO);
        }
        FILE_TO_TO_STORAGE_TYPE = Collections.unmodifiableMap(map);
    }
}

