/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogMfsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogMfsUtils.class);
    private static final String PUBLIC_ACE = "rf:p,wf:p,ef:p,rd:p,ac:p,dc:p,ld:p";

    public static String buildACEStrForUsers(String users) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        StringBuilder aceUserList = new StringBuilder();
        aceUserList.append(":(");
        for (String user : users.split(",")) {
            aceUserList.append("u:").append(user).append("|");
        }
        aceUserList.append("u:").append(ugi.getShortUserName()).append(")");
        StringBuilder ace = new StringBuilder();
        ace.append(UsersACLsManager.ACE.READ_FILE);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.WRITE_FILE);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.EXECUTE_FILE);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.READ_DIR);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.LOOKUP_DIR);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.ADD_CHILD);
        ace.append((CharSequence)aceUserList);
        ace.append(",").append(UsersACLsManager.ACE.DELETE_CHILD);
        ace.append((CharSequence)aceUserList);
        return ace.toString();
    }

    public static void changeCatalogAce(AbstractMapRFileSystem fs, String location, String users) throws IOException {
        String ace = CatalogMfsUtils.buildACEStrForUsers(users);
        fs.setAces(new Path(location), ace, true, 0, 0, true);
    }

    public static void changeCatalogDirectoryPermission(String location, String users, String catalogName) {
        try {
            AbstractMapRFileSystem mfs = (AbstractMapRFileSystem)FileSystem.get((URI)new URI(location), (Configuration)new Configuration());
            if (users != null && !users.isEmpty() && !users.equals("*")) {
                CatalogMfsUtils.changeCatalogAce(mfs, location, users);
            } else {
                mfs.setAces(new Path(location), PUBLIC_ACE, true, 0, 0, true);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't change ACE for catalog {}", (Object)catalogName, (Object)e);
        }
    }
}

