/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.service.auth.DecodedToken;
import org.apache.polaris.service.auth.TokenResponse;
import org.apache.polaris.service.types.TokenType;

public interface TokenBroker {
    public boolean supportsGrantType(String var1);

    public boolean supportsRequestedTokenType(TokenType var1);

    @Deprecated
    default public TokenResponse generateFromClientSecrets(String clientId, String clientSecret, String grantType, String scope, PolarisCallContext polarisCallContext) {
        return this.generateFromClientSecrets(clientId, clientSecret, grantType, scope, polarisCallContext, TokenType.ACCESS_TOKEN);
    }

    public TokenResponse generateFromClientSecrets(String var1, String var2, String var3, String var4, PolarisCallContext var5, TokenType var6);

    @Deprecated
    default public TokenResponse generateFromToken(TokenType subjectTokenType, String subjectToken, String grantType, String scope) {
        return this.generateFromToken(subjectTokenType, subjectToken, grantType, scope, TokenType.ACCESS_TOKEN);
    }

    public TokenResponse generateFromToken(TokenType var1, String var2, String var3, String var4, TokenType var5);

    public DecodedToken verify(String var1);

    @Nonnull
    public static Optional<PrincipalEntity> findPrincipalEntity(PolarisMetaStoreManager metaStoreManager, String clientId, String clientSecret, PolarisCallContext polarisCallContext) {
        PrincipalSecretsResult principalSecrets = metaStoreManager.loadPrincipalSecrets(polarisCallContext, clientId);
        if (!principalSecrets.isSuccess()) {
            return Optional.empty();
        }
        if (!principalSecrets.getPrincipalSecrets().matchesSecret(clientSecret)) {
            return Optional.empty();
        }
        EntityResult result = metaStoreManager.loadEntity(polarisCallContext, 0L, principalSecrets.getPrincipalSecrets().getPrincipalId(), PolarisEntityType.PRINCIPAL);
        if (!result.isSuccess() || result.getEntity().getType() != PolarisEntityType.PRINCIPAL) {
            return Optional.empty();
        }
        return Optional.of(PrincipalEntity.of((PolarisBaseEntity)result.getEntity()));
    }
}

